@extends('admin.layouts.admin_layout')
@section('content')
<style type="text/css">
    .table td, .table th {
        font-size: 12px;
        line-height: 2.42857 !important;
    }	
</style>
<div class="page-content-wrapper"> 
    <!-- BEGIN CONTENT BODY -->
    <div class="page-content"> 
        <!-- BEGIN PAGE HEADER--> 
        <!-- BEGIN PAGE BAR -->
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li> <a href="{{ route('admin.home') }}">Home</a> <i class="fa fa-circle"></i> </li>
                <li> <span>Job Skills</span> </li>
            </ul>
        </div>
        <!-- END PAGE BAR --> 
        <!-- BEGIN PAGE TITLE-->
        <h3 class="page-title">Manage Job Skills <small>Job Skills</small> </h3>
        <!-- END PAGE TITLE--> 
        <!-- END PAGE HEADER-->
        <div class="row">
            <div class="col-md-12"> 
                <!-- Begin: life time stats -->
                <div class="portlet light portlet-fit portlet-datatable bordered">
                    <div class="portlet-title">
                        <div class="caption"> <i class="icon-settings font-dark"></i> <span class="caption-subject font-dark sbold uppercase">Job Skills</span> </div>
                        <div class="actions"> 
                            <a href="{{ route('create.job.skill') }}" class="btn btn-xs btn-success"><i class="glyphicon glyphicon-plus"></i> Add New Job Skill</a>
                            <button type="button" id="bulkDeleteJobSkills" class="btn btn-xs btn-danger" style="display:none;"><i class="fa fa-trash"></i> Bulk Delete</button>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <div class="table-container">
                            <form method="post" role="form" id="jobSkill-search-form">
                                <table class="table table-striped table-bordered table-hover"  id="jobSkillDatatableAjax">
                                    <thead>
                                        <tr role="row" class="filter"> 
                                            <td></td>
                                            <td>{!! Form::select('lang', ['' => 'Select Language']+$languages, config('default_lang'), array('id'=>'lang', 'class'=>'form-control')) !!}</td>
                                            <td><input type="text" class="form-control" name="job_skill" id="job_skill" autocomplete="off" placeholder="Job Skill"></td>                      
                                            <td><select name="is_active" id="is_active"  class="form-control">
                                                    <option value="-1">Is Active?</option>
                                                    <option value="1" selected="selected">Active</option>
                                                    <option value="0">In Active</option>
                                                </select></td></tr>
                                        <tr role="row" class="heading">                                            
                                            <th><input type="checkbox" id="selectAllJobSkills" /></th>
                                            <th>Language</th>
                                            <th>Job Skill</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- END CONTENT BODY --> 
</div>
@endsection
@push('scripts') 
<script>
    $(function () {
        var oTable = $('#jobSkillDatatableAjax').DataTable({
            processing: true,
            serverSide: true,
            stateSave: true,
            searching: false,
            /*		
             "order": [[1, "asc"]],            
             paging: true,
             info: true,
             */
            ajax: {
                url: '{!! route('fetch.data.job.skills') !!}',
                data: function (d) {
                    d.lang = $('#lang').val();
                    d.job_skill = $('input[name=job_skill]').val();
                    d.is_active = $('#is_active').val();
                }
            }, columns: [
                {data: 'checkbox', name: 'checkbox', orderable: false, searchable: false},
                {data: 'lang', name: 'lang'},
                {data: 'job_skill', name: 'job_skill'},
                {data: 'action', name: 'action', orderable: false, searchable: false}
            ]
        });
        $('#jobSkill-search-form').on('submit', function (e) {
            oTable.draw();
            e.preventDefault();
        });
        $('#lang').on('change', function (e) {
            oTable.draw();
            e.preventDefault();
        });
        $('#job_skill').on('keyup', function (e) {
            oTable.draw();
            e.preventDefault();
        });
        $('#is_active').on('change', function (e) {
            oTable.draw();
            e.preventDefault();
        });
    });
    function deleteJobSkill(id, is_default) {
        var msg = 'Are you sure?';
        if (is_default == 1) {
            msg = 'Are you sure? You are going to delete default Job Skill, all other non default Job Skills will be deleted too!';
        }
        if (confirm(msg)) {
            $.post("{{ route('delete.job.skill') }}", {id: id, _method: 'DELETE', _token: '{{ csrf_token() }}'})
                    .done(function (response) {
                        if (response == 'ok')
                        {
                            var table = $('#jobSkillDatatableAjax').DataTable();
                            table.row('jobSkillDtRow' + id).remove().draw(false);
                        } else
                        {
                            alert('Request Failed!');
                        }
                    });
        }
    }
    function makeActive(id) {
        $.post("{{ route('make.active.job.skill') }}", {id: id, _method: 'PUT', _token: '{{ csrf_token() }}'})
                .done(function (response) {
                    if (response == 'ok')
                    {
                        var table = $('#jobSkillDatatableAjax').DataTable();
                        table.row('jobSkillDtRow' + id).remove().draw(false);
                    } else
                    {
                        alert('Request Failed!');
                    }
                });
    }
    function makeNotActive(id) {
        $.post("{{ route('make.not.active.job.skill') }}", {id: id, _method: 'PUT', _token: '{{ csrf_token() }}'})
                .done(function (response) {
                    if (response == 'ok')
                    {
                        var table = $('#jobSkillDatatableAjax').DataTable();
                        table.row('jobSkillDtRow' + id).remove().draw(false);
                    } else
                    {
                        alert('Request Failed!');
                    }
                });
    }
    
    // Select All functionality
    $(document).on('change', '#selectAllJobSkills', function() {
        $('.checkboxes').prop('checked', this.checked);
        toggleBulkDeleteButton();
    });
    
    $(document).on('change', '.checkboxes', function() {
        var totalCheckboxes = $('.checkboxes').length;
        var checkedCheckboxes = $('.checkboxes:checked').length;
        $('#selectAllJobSkills').prop('checked', totalCheckboxes === checkedCheckboxes);
        toggleBulkDeleteButton();
    });
    
    function toggleBulkDeleteButton() {
        var checkedCount = $('.checkboxes:checked').length;
        if (checkedCount > 0) {
            $('#bulkDeleteJobSkills').show();
        } else {
            $('#bulkDeleteJobSkills').hide();
        }
    }
    
    // Bulk Delete functionality
    $('#bulkDeleteJobSkills').on('click', function() {
        var selectedIds = [];
        $('.checkboxes:checked').each(function() {
            selectedIds.push($(this).val());
        });
        
        if (selectedIds.length === 0) {
            alert('Please select at least one item to delete.');
            return;
        }
        
        if (confirm('Are you sure you want to delete ' + selectedIds.length + ' selected item(s)?')) {
            $.ajax({
                url: '{{ route('bulk.delete.job.skills') }}',
                type: 'POST',
                data: {
                    ids: selectedIds,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    if (response.success) {
                        alert(response.message);
                        var table = $('#jobSkillDatatableAjax').DataTable();
                        table.draw();
                        $('#selectAllJobSkills').prop('checked', false);
                        toggleBulkDeleteButton();
                    } else {
                        alert(response.message || 'Error deleting items');
                    }
                },
                error: function() {
                    alert('Error deleting items');
                }
            });
        }
    });
</script> 
@endpush