import*as e from"../../core/common/common.js";import*as t from"../../core/host/host.js";import*as s from"../../core/i18n/i18n.js";import*as i from"../../core/sdk/sdk.js";import*as r from"../../third_party/marked/marked.js";import*as o from"../../core/root/root.js";import*as n from"../../third_party/third-party-web/third-party-web.js";import*as a from"../bindings/bindings.js";import*as u from"../workspace/workspace.js";const l={improvements:"Improvements",pageErrors:"Page Errors",breakingChanges:"Breaking Changes",pageErrorIssue:"A page error issue: the page is not working correctly",breakingChangeIssue:"A breaking change issue: the page may stop working in an upcoming version of Chrome",improvementIssue:"An improvement issue: there is an opportunity to improve the page"},d=s.i18n.registerUIStrings("models/issues_manager/Issue.ts",l),c=s.i18n.getLocalizedString.bind(void 0,d);class g{#e;#t;issueId=void 0;#s;constructor(e,s=null,i){this.#e="object"==typeof e?e.code:e,this.#t=s,this.issueId=i,t.userMetrics.issueCreated("string"==typeof e?e:e.umaCode),this.#s=!1}code(){return this.#e}getBlockedByResponseDetails(){return[]}cookies(){return[]}rawCookieLines(){return[]}elements(){return[]}requests(){return[]}sources(){return[]}trackingSites(){return[]}isAssociatedWithRequestId(e){for(const t of this.requests())if(t.requestId===e)return!0;return!1}model(){return this.#t}isCausedByThirdParty(){return!1}getIssueId(){return this.issueId}isHidden(){return this.#s}setHidden(e){this.#s=e}maybeCreateConsoleMessage(){}}function h(e){if(e)return{url:e.url,scriptId:e.scriptId,lineNumber:e.lineNumber,columnNumber:0===e.columnNumber?void 0:e.columnNumber-1}}var m=Object.freeze({__proto__:null,Issue:g,getIssueKindDescription:function(e){switch(e){case"PageError":return c(l.pageErrorIssue);case"BreakingChange":return c(l.breakingChangeIssue);case"Improvement":return c(l.improvementIssue)}},getIssueKindName:function(e){switch(e){case"BreakingChange":return c(l.breakingChanges);case"Improvement":return c(l.improvements);case"PageError":return c(l.pageErrors)}},getShowThirdPartyIssuesSetting:function(){return e.Settings.Settings.instance().createSetting("show-third-party-issues",!0)},toZeroBasedLocation:h,unionIssueKind:function(e,t){return"PageError"===e||"PageError"===t?"PageError":"BreakingChange"===e||"BreakingChange"===t?"BreakingChange":"Improvement"}});const p={link:"https://tools.ietf.org/id/draft-ietf-httpbis-header-structure-15.html#rfc.section.4.2.2",linkTitle:"Structured Headers RFC"};class I extends g{issueDetails;constructor(e,t){super(function(e){switch(e.violationType){case"PermissionPolicyDisabled":return"AttributionReportingIssue::PermissionPolicyDisabled";case"UntrustworthyReportingOrigin":return"AttributionReportingIssue::UntrustworthyReportingOrigin";case"InsecureContext":return"AttributionReportingIssue::InsecureContext";case"InvalidHeader":return"AttributionReportingIssue::InvalidRegisterSourceHeader";case"InvalidRegisterTriggerHeader":return"AttributionReportingIssue::InvalidRegisterTriggerHeader";case"SourceAndTriggerHeaders":return"AttributionReportingIssue::SourceAndTriggerHeaders";case"SourceIgnored":return"AttributionReportingIssue::SourceIgnored";case"TriggerIgnored":return"AttributionReportingIssue::TriggerIgnored";case"OsSourceIgnored":return"AttributionReportingIssue::OsSourceIgnored";case"OsTriggerIgnored":return"AttributionReportingIssue::OsTriggerIgnored";case"InvalidRegisterOsSourceHeader":return"AttributionReportingIssue::InvalidRegisterOsSourceHeader";case"InvalidRegisterOsTriggerHeader":return"AttributionReportingIssue::InvalidRegisterOsTriggerHeader";case"WebAndOsHeaders":return"AttributionReportingIssue::WebAndOsHeaders";case"NoWebOrOsSupport":return"AttributionReportingIssue::NoWebOrOsSupport";case"NavigationRegistrationWithoutTransientUserActivation":return"AttributionReportingIssue::NavigationRegistrationWithoutTransientUserActivation";case"InvalidInfoHeader":return"AttributionReportingIssue::InvalidInfoHeader";case"NoRegisterSourceHeader":return"AttributionReportingIssue::NoRegisterSourceHeader";case"NoRegisterTriggerHeader":return"AttributionReportingIssue::NoRegisterTriggerHeader";case"NoRegisterOsSourceHeader":return"AttributionReportingIssue::NoRegisterOsSourceHeader";case"NoRegisterOsTriggerHeader":return"AttributionReportingIssue::NoRegisterOsTriggerHeader";case"NavigationRegistrationUniqueScopeAlreadySet":return"AttributionReportingIssue::NavigationRegistrationUniqueScopeAlreadySet";default:return"AttributionReportingIssue::Unknown"}}(e),t),this.issueDetails=e}getCategory(){return"AttributionReporting"}getHeaderValidatorLink(e){const t=new URL("https://wicg.github.io/attribution-reporting-api/validate-headers");return t.searchParams.set("header",e),this.issueDetails.invalidParameter&&t.searchParams.set("json",this.issueDetails.invalidParameter),{link:t.toString(),linkTitle:"Header Validator"}}getDescription(){switch(this.code()){case"AttributionReportingIssue::PermissionPolicyDisabled":return{file:"arPermissionPolicyDisabled.md",links:[]};case"AttributionReportingIssue::UntrustworthyReportingOrigin":return{file:"arUntrustworthyReportingOrigin.md",links:[]};case"AttributionReportingIssue::InsecureContext":return{file:"arInsecureContext.md",links:[]};case"AttributionReportingIssue::InvalidRegisterSourceHeader":return{file:"arInvalidRegisterSourceHeader.md",links:[this.getHeaderValidatorLink("source")]};case"AttributionReportingIssue::InvalidRegisterTriggerHeader":return{file:"arInvalidRegisterTriggerHeader.md",links:[this.getHeaderValidatorLink("trigger")]};case"AttributionReportingIssue::InvalidRegisterOsSourceHeader":return{file:"arInvalidRegisterOsSourceHeader.md",links:[this.getHeaderValidatorLink("os-source")]};case"AttributionReportingIssue::InvalidRegisterOsTriggerHeader":return{file:"arInvalidRegisterOsTriggerHeader.md",links:[this.getHeaderValidatorLink("os-trigger")]};case"AttributionReportingIssue::SourceAndTriggerHeaders":return{file:"arSourceAndTriggerHeaders.md",links:[]};case"AttributionReportingIssue::WebAndOsHeaders":return{file:"arWebAndOsHeaders.md",links:[]};case"AttributionReportingIssue::SourceIgnored":return{file:"arSourceIgnored.md",links:[p]};case"AttributionReportingIssue::TriggerIgnored":return{file:"arTriggerIgnored.md",links:[p]};case"AttributionReportingIssue::OsSourceIgnored":return{file:"arOsSourceIgnored.md",links:[p]};case"AttributionReportingIssue::OsTriggerIgnored":return{file:"arOsTriggerIgnored.md",links:[p]};case"AttributionReportingIssue::NavigationRegistrationWithoutTransientUserActivation":return{file:"arNavigationRegistrationWithoutTransientUserActivation.md",links:[]};case"AttributionReportingIssue::NoWebOrOsSupport":return{file:"arNoWebOrOsSupport.md",links:[]};case"AttributionReportingIssue::InvalidInfoHeader":return{file:"arInvalidInfoHeader.md",links:[]};case"AttributionReportingIssue::NoRegisterSourceHeader":return{file:"arNoRegisterSourceHeader.md",links:[]};case"AttributionReportingIssue::NoRegisterTriggerHeader":return{file:"arNoRegisterTriggerHeader.md",links:[]};case"AttributionReportingIssue::NoRegisterOsSourceHeader":return{file:"arNoRegisterOsSourceHeader.md",links:[]};case"AttributionReportingIssue::NoRegisterOsTriggerHeader":return{file:"arNoRegisterOsTriggerHeader.md",links:[]};case"AttributionReportingIssue::NavigationRegistrationUniqueScopeAlreadySet":return{file:"arNavigationRegistrationUniqueScopeAlreadySet.md",links:[]};case"AttributionReportingIssue::Unknown":return null}}primaryKey(){return JSON.stringify(this.issueDetails)}getKind(){return"PageError"}static fromInspectorIssue(e,t){const{attributionReportingIssueDetails:s}=t.details;return s?[new I(s,e)]:(console.warn("Attribution Reporting issue without details received."),[])}}var f=Object.freeze({__proto__:null,AttributionReportingIssue:I});let k=null;class C{constructor(){i.TargetManager.TargetManager.instance().addModelListener(i.ResourceTreeModel.ResourceTreeModel,i.ResourceTreeModel.Events.Load,this.#i,this,{scoped:!0});for(const e of i.TargetManager.TargetManager.instance().models(i.ResourceTreeModel.ResourceTreeModel))e.target().outermostTarget()===e.target()&&this.#r(e)}static instance({forceNew:e}={forceNew:!1}){return k&&!e||(k=new C),k}#r(e){e.target().auditsAgent().invoke_checkFormsIssues()}#i(e){const{resourceTreeModel:t}=e.data;this.#r(t)}}var y=Object.freeze({__proto__:null,CheckFormsIssuesTrigger:C});function S(e){const t=new Map;e.substitutions?.forEach(((e,s)=>{t.set(s,e())}));return{file:e.file,links:e.links.map((function(e){return{link:e.link,linkTitle:e.linkTitle()}})),substitutions:t}}async function b(e){try{const t=await fetch(e.toString());return await t.text()}catch{throw new Error(`Markdown file ${e.toString()} not found. Make sure it is correctly listed in the relevant BUILD.gn files.`)}}async function v(e){return await b(new URL(`descriptions/${e}`,import.meta.url))}function w(e,t){const s=r.Marked.lexer(e),i=A(s);if(!i)throw new Error("Markdown issue descriptions must start with a heading");return{title:i,markdown:s.slice(1),links:t.links}}const D=/\{(PLACEHOLDER_[a-zA-Z][a-zA-Z0-9]*)\}/g,R=/PLACEHOLDER_[a-zA-Z][a-zA-Z0-9]*/;function T(e,t){const s=new Set(t?t.keys():[]);!function(e){const t=[...e].filter((e=>!R.test(e)));if(t.length>0)throw new Error(`Invalid placeholders provided in the substitutions map: ${t}`)}(s);const i=e.replace(D,((e,i)=>{const r=t?t.get(i):void 0;if(void 0===r)throw new Error(`No replacement provided for placeholder '${i}'.`);return s.delete(i),r}));if(s.size>0)throw new Error(`Unused replacements provided: ${[...s]}`);return i}function A(e){return 0===e.length||"heading"!==e[0].type||1!==e[0].depth?null:e[0].text}async function E(e){const t=await v(e.file);return A(r.Marked.lexer(t))}var P=Object.freeze({__proto__:null,createIssueDescriptionFromMarkdown:async function(e){return w(T(await v(e.file),e.substitutions),e)},createIssueDescriptionFromRawMarkdown:w,findTitleFromMarkdownAst:A,getFileContent:b,getIssueTitleFromMarkdownDescription:E,getMarkdownFileContent:v,resolveLazyDescription:S,substitutePlaceholders:T});const M={clientHintsInfrastructure:"Client Hints Infrastructure"},N=s.i18n.registerUIStrings("models/issues_manager/ClientHintIssue.ts",M),F=s.i18n.getLazilyComputedLocalizedString.bind(void 0,N);class L extends g{issueDetails;constructor(e,t){super({code:"ClientHintIssue",umaCode:["ClientHintIssue",e.clientHintIssueReason].join("::")},t),this.issueDetails=e}getCategory(){return"Other"}details(){return this.issueDetails}getDescription(){const e=x.get(this.issueDetails.clientHintIssueReason);return e?S(e):null}sources(){return[this.issueDetails.sourceCodeLocation]}primaryKey(){return JSON.stringify(this.issueDetails)}getKind(){return"BreakingChange"}static fromInspectorIssue(e,t){const s=t.details.clientHintIssueDetails;return s?[new L(s,e)]:(console.warn("Client Hint issue without details received."),[])}}const x=new Map([["MetaTagAllowListInvalidOrigin",{file:"clientHintMetaTagAllowListInvalidOrigin.md",links:[{link:"https://wicg.github.io/client-hints-infrastructure/",linkTitle:F(M.clientHintsInfrastructure)}]}],["MetaTagModifiedHTML",{file:"clientHintMetaTagModifiedHTML.md",links:[{link:"https://wicg.github.io/client-hints-infrastructure/",linkTitle:F(M.clientHintsInfrastructure)}]}]]);var O=Object.freeze({__proto__:null,ClientHintIssue:L});const W={contentSecurityPolicySource:"Content Security Policy - Source Allowlists",contentSecurityPolicyInlineCode:"Content Security Policy - Inline Code",contentSecurityPolicyEval:"Content Security Policy - Eval",trustedTypesFixViolations:"Trusted Types - Fix violations",trustedTypesPolicyViolation:"Trusted Types - Policy violation"},H=s.i18n.registerUIStrings("models/issues_manager/ContentSecurityPolicyIssue.ts",W),U=s.i18n.getLazilyComputedLocalizedString.bind(void 0,H);class _ extends g{#o;constructor(e,t,s){super(["ContentSecurityPolicyIssue",e.contentSecurityPolicyViolationType].join("::"),t,s),this.#o=e}getCategory(){return"ContentSecurityPolicy"}primaryKey(){return JSON.stringify(this.#o,["blockedURL","contentSecurityPolicyViolationType","violatedDirective","isReportOnly","sourceCodeLocation","url","lineNumber","columnNumber","violatingNodeId"])}getDescription(){const e=Y.get(this.#o.contentSecurityPolicyViolationType);return e?S(e):null}details(){return this.#o}getKind(){return this.#o.isReportOnly?"Improvement":"PageError"}static fromInspectorIssue(e,t){const s=t.details.contentSecurityPolicyIssueDetails;return s?[new _(s,e,t.issueId)]:(console.warn("Content security policy issue without details received."),[])}}const q={file:"cspURLViolation.md",links:[{link:"https://developers.google.com/web/fundamentals/security/csp#source_allowlists",linkTitle:U(W.contentSecurityPolicySource)}]},B={file:"cspInlineViolation.md",links:[{link:"https://developers.google.com/web/fundamentals/security/csp#inline_code_is_considered_harmful",linkTitle:U(W.contentSecurityPolicyInlineCode)}]},z={file:"cspEvalViolation.md",links:[{link:"https://developers.google.com/web/fundamentals/security/csp#eval_too",linkTitle:U(W.contentSecurityPolicyEval)}]},V={file:"cspTrustedTypesSinkViolation.md",links:[{link:"https://web.dev/trusted-types/#fix-the-violations",linkTitle:U(W.trustedTypesFixViolations)}]},j={file:"cspTrustedTypesPolicyViolation.md",links:[{link:"https://web.dev/trusted-types/",linkTitle:U(W.trustedTypesPolicyViolation)}]},K=["ContentSecurityPolicyIssue","kURLViolation"].join("::"),$=["ContentSecurityPolicyIssue","kInlineViolation"].join("::"),G=["ContentSecurityPolicyIssue","kEvalViolation"].join("::"),J=["ContentSecurityPolicyIssue","kTrustedTypesSinkViolation"].join("::"),Q=["ContentSecurityPolicyIssue","kTrustedTypesPolicyViolation"].join("::"),Y=new Map([["kURLViolation",q],["kInlineViolation",B],["kEvalViolation",z],["kTrustedTypesSinkViolation",V],["kTrustedTypesPolicyViolation",j]]);var X=Object.freeze({__proto__:null,ContentSecurityPolicyIssue:_,evalViolationCode:G,inlineViolationCode:$,trustedTypesPolicyViolationCode:Q,trustedTypesSinkViolationCode:J,urlViolationCode:K});let Z=null;class ee{#n=new WeakMap;#a=new WeakMap;constructor(){i.TargetManager.TargetManager.instance().observeModels(i.ResourceTreeModel.ResourceTreeModel,this)}static instance({forceNew:e}={forceNew:!1}){return Z&&!e||(Z=new ee),Z}async modelAdded(e){this.#n.set(e,e.addEventListener(i.ResourceTreeModel.Events.Load,this.#i,this)),this.#a.set(e,e.addEventListener(i.ResourceTreeModel.Events.FrameAdded,this.#u,this))}modelRemoved(t){const s=this.#n.get(t);s&&e.EventTarget.removeEventListeners([s]);const i=this.#a.get(t);i&&e.EventTarget.removeEventListeners([i])}#l(e){o.Runtime.experiments.isEnabled("contrast-issues")&&e.target().auditsAgent().invoke_checkContrast({})}#i(e){const{resourceTreeModel:t}=e.data;this.#l(t)}async#u(e){if(!o.Runtime.experiments.isEnabled("contrast-issues"))return;const t=e.data;if(!t.isMainFrame())return;const s=await t.resourceTreeModel().target().runtimeAgent().invoke_evaluate({expression:"document.readyState",returnByValue:!0});s.result&&"complete"===s.result.value&&this.#l(t.resourceTreeModel())}}var te=Object.freeze({__proto__:null,ContrastCheckTrigger:ee});const se={thirdPartyPhaseoutExplained:"Changes to Chrome's treatment of third-party cookies"},ie=s.i18n.registerUIStrings("models/issues_manager/CookieDeprecationMetadataIssue.ts",se),re=s.i18n.getLocalizedString.bind(void 0,ie);class oe extends g{#o;constructor(e,t){super("CookieDeprecationMetadataIssue_"+e.operation,t),this.#o=e}getCategory(){return"Other"}getDescription(){const e="SetCookie"===this.#o.operation?"cookieWarnMetadataGrantSet.md":"cookieWarnMetadataGrantRead.md";let t="";return this.#o.isOptOutTopLevel&&(t="\n\n (Top level site opt-out: "+this.#o.optOutPercentage+"% - [learn more](gracePeriodStagedControlExplainer))"),{file:e,substitutions:new Map([["PLACEHOLDER_topleveloptout",t]]),links:[{link:"https://goo.gle/changes-to-chrome-browsing",linkTitle:re(se.thirdPartyPhaseoutExplained)}]}}details(){return this.#o}getKind(){return"BreakingChange"}primaryKey(){return JSON.stringify(this.#o)}static fromInspectorIssue(e,t){const s=t.details.cookieDeprecationMetadataIssueDetails;return s?[new oe(s,e)]:(console.warn("Cookie deprecation metadata issue without details received."),[])}}var ne=Object.freeze({__proto__:null,CookieDeprecationMetadataIssue:oe});const ae={samesiteCookiesExplained:"SameSite cookies explained",howSchemefulSamesiteWorks:"How Schemeful Same-Site Works",firstPartySetsExplained:"`First-Party Sets` and the `SameParty` attribute",thirdPartyPhaseoutExplained:"Changes to Chrome's treatment of third-party cookies",fileCrosSiteRedirectBug:"File a bug",consoleTpcdWarningMessage:"Chrome is moving towards a new experience that allows users to choose to browse without third-party cookies.",consoleTpcdErrorMessage:"Third-party cookie is blocked in Chrome either because of Chrome flags or browser configuration."},ue=s.i18n.registerUIStrings("models/issues_manager/CookieIssue.ts",ae),le=s.i18n.getLazilyComputedLocalizedString.bind(void 0,ue);class de extends g{#o;constructor(e,t,s,i){super(e,s,i),this.#o=t}cookieId(){if(this.#o.cookie){const{domain:e,path:t,name:s}=this.#o.cookie;return`${e};${t};${s}`}return this.#o.rawCookieLine??"no-cookie-info"}primaryKey(){const e=this.#o.request?this.#o.request.requestId:"no-request";return`${this.code()}-(${this.cookieId()})-(${e})`}static createIssuesFromCookieIssueDetails(e,t,s){const i=[];if(e.cookieExclusionReasons&&e.cookieExclusionReasons.length>0){for(const r of e.cookieExclusionReasons){const o=de.codeForCookieIssueDetails(r,e.cookieWarningReasons,e.operation,e.cookieUrl);o&&i.push(new de(o,e,t,s))}return i}if(e.cookieWarningReasons)for(const r of e.cookieWarningReasons){const o=de.codeForCookieIssueDetails(r,[],e.operation,e.cookieUrl);o&&i.push(new de(o,e,t,s))}return i}static codeForCookieIssueDetails(t,s,i,r){const o=r&&(e.ParsedURL.schemeIs(r,"https:")||e.ParsedURL.schemeIs(r,"wss:"))?"Secure":"Insecure";if("ExcludeSameSiteStrict"===t||"ExcludeSameSiteLax"===t||"ExcludeSameSiteUnspecifiedTreatedAsLax"===t){if(s&&s.length>0){if(s.includes("WarnSameSiteStrictLaxDowngradeStrict"))return["CookieIssue","ExcludeNavigationContextDowngrade",o].join("::");if(s.includes("WarnSameSiteStrictCrossDowngradeStrict")||s.includes("WarnSameSiteStrictCrossDowngradeLax")||s.includes("WarnSameSiteLaxCrossDowngradeStrict")||s.includes("WarnSameSiteLaxCrossDowngradeLax"))return["CookieIssue","ExcludeContextDowngrade",i,o].join("::")}return s.includes("WarnCrossSiteRedirectDowngradeChangesInclusion")?["CookieIssue","CrossSiteRedirectDowngradeChangesInclusion"].join("::"):"ExcludeSameSiteUnspecifiedTreatedAsLax"===t?["CookieIssue",t,i].join("::"):null}return"WarnSameSiteStrictLaxDowngradeStrict"===t?["CookieIssue",t,o].join("::"):"WarnSameSiteStrictCrossDowngradeStrict"===t||"WarnSameSiteStrictCrossDowngradeLax"===t||"WarnSameSiteLaxCrossDowngradeLax"===t||"WarnSameSiteLaxCrossDowngradeStrict"===t?["CookieIssue","WarnCrossDowngrade",i,o].join("::"):"ExcludePortMismatch"===t?["CookieIssue","ExcludePortMismatch"].join("::"):"ExcludeSchemeMismatch"===t?["CookieIssue","ExcludeSchemeMismatch"].join("::"):["CookieIssue",t,i].join("::")}cookies(){return this.#o.cookie?[this.#o.cookie]:[]}rawCookieLines(){return this.#o.rawCookieLine?[this.#o.rawCookieLine]:[]}requests(){return this.#o.request?[this.#o.request]:[]}getCategory(){return"Cookie"}getDescription(){const e=He.get(this.code());return e?S(e):null}isCausedByThirdParty(){return ce(i.FrameManager.FrameManager.instance().getOutermostFrame(),this.#o.cookieUrl,this.#o.siteForCookies)}getKind(){return this.#o.cookieExclusionReasons?.length>0?"PageError":"BreakingChange"}makeCookieReportEntry(){const e=de.getCookieStatus(this.#o);if(this.#o.cookie&&this.#o.cookieUrl&&void 0!==e){const t=n.ThirdPartyWeb.getEntity(this.#o.cookieUrl);return{name:this.#o.cookie.name,domain:this.#o.cookie.domain,type:t?.category,platform:t?.name,status:e,insight:this.#o.insight}}}static getCookieStatus(e){return e.cookieExclusionReasons.includes("ExcludeThirdPartyPhaseout")?0:e.cookieWarningReasons.includes("WarnDeprecationTrialMetadata")?2:e.cookieWarningReasons.includes("WarnThirdPartyCookieHeuristic")?3:e.cookieWarningReasons.includes("WarnThirdPartyPhaseout")?1:void 0}static fromInspectorIssue(e,t){const s=t.details.cookieIssueDetails;return s?de.createIssuesFromCookieIssueDetails(s,e,t.issueId):(console.warn("Cookie issue without details received."),[])}static getSubCategory(e){return e.includes("SameSite")||e.includes("Downgrade")?"SameSiteCookie":e.includes("ThirdPartyPhaseout")?"ThirdPartyPhaseoutCookie":"GenericCookie"}maybeCreateConsoleMessage(){const t=this.model();if(t&&"ThirdPartyPhaseoutCookie"===de.getSubCategory(this.code()))return new i.ConsoleModel.ConsoleMessage(t.target().model(i.RuntimeModel.RuntimeModel),e.Console.FrontendMessageSource.ISSUE_PANEL,"warning","PageError"===this.getKind()?ae.consoleTpcdErrorMessage:ae.consoleTpcdWarningMessage,{url:this.#o.request?.url,affectedResources:{requestId:this.#o.request?.requestId,issueId:this.issueId},isCookieReportIssue:!0})}}function ce(t,s,i){if(!t)return!0;if(!i)return!0;if(!s||""===t.domainAndRegistry())return!1;const r=e.ParsedURL.ParsedURL.fromString(s);return!!r&&!function(e,t){if(e.length<=t.length)return e===t;if(!e.endsWith(t))return!1;return e.substr(0,e.length-t.length).endsWith(".")}(r.domain(),t.domainAndRegistry())}const ge={file:"SameSiteUnspecifiedLaxAllowUnsafeRead.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:le(ae.samesiteCookiesExplained)}]},he={file:"SameSiteUnspecifiedLaxAllowUnsafeSet.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:le(ae.samesiteCookiesExplained)}]},me={file:"SameSiteNoneInsecureErrorRead.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:le(ae.samesiteCookiesExplained)}]},pe={file:"SameSiteNoneInsecureErrorSet.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:le(ae.samesiteCookiesExplained)}]},Ie={file:"SameSiteNoneInsecureWarnRead.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:le(ae.samesiteCookiesExplained)}]},fe={file:"SameSiteNoneInsecureWarnSet.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:le(ae.samesiteCookiesExplained)}]},ke=[{link:"https://web.dev/schemeful-samesite/",linkTitle:le(ae.howSchemefulSamesiteWorks)}];function Ce({isDestinationSecure:e,isOriginSecure:t}){return new Map([["PLACEHOLDER_destination",()=>e?"a secure":"an insecure"],["PLACEHOLDER_origin",()=>t?"a secure":"an insecure"]])}function ye(e){return{file:"SameSiteWarnStrictLaxDowngradeStrict.md",substitutions:Ce({isDestinationSecure:e,isOriginSecure:!e}),links:ke}}function Se(e){return{file:"SameSiteExcludeNavigationContextDowngrade.md",substitutions:Ce({isDestinationSecure:e,isOriginSecure:!e}),links:ke}}function be(e){return{file:"SameSiteWarnCrossDowngradeRead.md",substitutions:Ce({isDestinationSecure:e,isOriginSecure:!e}),links:ke}}function ve(e){return{file:"SameSiteExcludeContextDowngradeRead.md",substitutions:Ce({isDestinationSecure:e,isOriginSecure:!e}),links:ke}}function we(e){return{file:"SameSiteWarnCrossDowngradeSet.md",substitutions:Ce({isDestinationSecure:!e,isOriginSecure:e}),links:ke}}function De(e){return{file:"SameSiteExcludeContextDowngradeSet.md",substitutions:Ce({isDestinationSecure:e,isOriginSecure:!e}),links:ke}}const Re={file:"SameSiteInvalidSameParty.md",links:[{link:"https://developer.chrome.com/blog/first-party-sets-sameparty/",linkTitle:le(ae.firstPartySetsExplained)}]},Te={file:"SameSiteSamePartyCrossPartyContextSet.md",links:[{link:"https://developer.chrome.com/blog/first-party-sets-sameparty/",linkTitle:le(ae.firstPartySetsExplained)}]},Ae={file:"CookieAttributeValueExceedsMaxSize.md",links:[]},Ee={file:"cookieWarnDomainNonAscii.md",links:[]},Pe={file:"cookieExcludeDomainNonAscii.md",links:[]},Me={file:"cookieExcludeBlockedWithinRelatedWebsiteSet.md",links:[]},Ne={file:"cookieWarnThirdPartyPhaseoutSet.md",links:[{link:"https://goo.gle/3pc-dev-issue",linkTitle:le(ae.thirdPartyPhaseoutExplained)}]},Fe={file:"cookieWarnThirdPartyPhaseoutRead.md",links:[{link:"https://goo.gle/3pc-dev-issue",linkTitle:le(ae.thirdPartyPhaseoutExplained)}]},Le={file:"cookieExcludeThirdPartyPhaseoutSet.md",links:[{link:"https://goo.gle/report-3pc-dev-issue",linkTitle:le(ae.thirdPartyPhaseoutExplained)}]},xe={file:"cookieExcludeThirdPartyPhaseoutRead.md",links:[{link:"https://goo.gle/report-3pc-dev-issue",linkTitle:le(ae.thirdPartyPhaseoutExplained)}]},Oe={file:"cookieCrossSiteRedirectDowngrade.md",links:[{link:"https://bugs.chromium.org/p/chromium/issues/entry?template=Defect%20report%20from%20user&summary=[Cross-Site Redirect Chain] <INSERT BUG SUMMARY HERE>&comment=Chrome Version: (copy from chrome://version)%0AChannel: (e.g. Canary, Dev, Beta, Stable)%0A%0AAffected URLs:%0A%0AWhat is the expected result?%0A%0AWhat happens instead?%0A%0AWhat is the purpose of the cross-site redirect?:%0A%0AWhat steps will reproduce the problem?:%0A(1)%0A(2)%0A(3)%0A%0APlease provide any additional information below.&components=Internals%3ENetwork%3ECookies",linkTitle:le(ae.fileCrosSiteRedirectBug)}]},We={file:"placeholderDescriptionForInvisibleIssues.md",links:[]},He=new Map([["CookieIssue::WarnSameSiteUnspecifiedLaxAllowUnsafe::ReadCookie",ge],["CookieIssue::WarnSameSiteUnspecifiedLaxAllowUnsafe::SetCookie",he],["CookieIssue::WarnSameSiteUnspecifiedCrossSiteContext::ReadCookie",ge],["CookieIssue::WarnSameSiteUnspecifiedCrossSiteContext::SetCookie",he],["CookieIssue::ExcludeSameSiteNoneInsecure::ReadCookie",me],["CookieIssue::ExcludeSameSiteNoneInsecure::SetCookie",pe],["CookieIssue::WarnSameSiteNoneInsecure::ReadCookie",Ie],["CookieIssue::WarnSameSiteNoneInsecure::SetCookie",fe],["CookieIssue::WarnSameSiteStrictLaxDowngradeStrict::Secure",ye(!0)],["CookieIssue::WarnSameSiteStrictLaxDowngradeStrict::Insecure",ye(!1)],["CookieIssue::WarnCrossDowngrade::ReadCookie::Secure",be(!0)],["CookieIssue::WarnCrossDowngrade::ReadCookie::Insecure",be(!1)],["CookieIssue::WarnCrossDowngrade::SetCookie::Secure",we(!0)],["CookieIssue::WarnCrossDowngrade::SetCookie::Insecure",we(!1)],["CookieIssue::ExcludeNavigationContextDowngrade::Secure",Se(!0)],["CookieIssue::ExcludeNavigationContextDowngrade::Insecure",Se(!1)],["CookieIssue::ExcludeContextDowngrade::ReadCookie::Secure",ve(!0)],["CookieIssue::ExcludeContextDowngrade::ReadCookie::Insecure",ve(!1)],["CookieIssue::ExcludeContextDowngrade::SetCookie::Secure",De(!0)],["CookieIssue::ExcludeContextDowngrade::SetCookie::Insecure",De(!1)],["CookieIssue::ExcludeInvalidSameParty::SetCookie",Re],["CookieIssue::ExcludeSamePartyCrossPartyContext::SetCookie",Te],["CookieIssue::WarnAttributeValueExceedsMaxSize::ReadCookie",Ae],["CookieIssue::WarnAttributeValueExceedsMaxSize::SetCookie",Ae],["CookieIssue::WarnDomainNonASCII::ReadCookie",Ee],["CookieIssue::WarnDomainNonASCII::SetCookie",Ee],["CookieIssue::ExcludeDomainNonASCII::ReadCookie",Pe],["CookieIssue::ExcludeDomainNonASCII::SetCookie",Pe],["CookieIssue::ExcludeThirdPartyCookieBlockedInRelatedWebsiteSet::ReadCookie",Me],["CookieIssue::ExcludeThirdPartyCookieBlockedInRelatedWebsiteSet::SetCookie",Me],["CookieIssue::WarnThirdPartyPhaseout::ReadCookie",Fe],["CookieIssue::WarnThirdPartyPhaseout::SetCookie",Ne],["CookieIssue::WarnDeprecationTrialMetadata::ReadCookie",We],["CookieIssue::WarnDeprecationTrialMetadata::SetCookie",We],["CookieIssue::WarnThirdPartyCookieHeuristic::ReadCookie",We],["CookieIssue::WarnThirdPartyCookieHeuristic::SetCookie",We],["CookieIssue::ExcludeThirdPartyPhaseout::ReadCookie",xe],["CookieIssue::ExcludeThirdPartyPhaseout::SetCookie",Le],["CookieIssue::CrossSiteRedirectDowngradeChangesInclusion",Oe],["CookieIssue::ExcludePortMismatch",{file:"cookieExcludePortMismatch.md",links:[]}],["CookieIssue::ExcludeSchemeMismatch",{file:"cookieExcludeSchemeMismatch.md",links:[]}]]);var Ue=Object.freeze({__proto__:null,CookieIssue:de,isCausedByThirdParty:ce});const _e={corsLocalNetworkAccess:"Local Network Access",corsPrivateNetworkAccess:"Private Network Access",CORS:"Cross-Origin Resource Sharing (`CORS`)"},qe=s.i18n.registerUIStrings("models/issues_manager/CorsIssue.ts",_e),Be=s.i18n.getLocalizedString.bind(void 0,qe);function ze(e){switch(e.corsErrorStatus.corsError){case"InvalidAllowMethodsPreflightResponse":case"InvalidAllowHeadersPreflightResponse":case"PreflightMissingAllowOriginHeader":case"PreflightMultipleAllowOriginValues":case"PreflightInvalidAllowOriginValue":case"MissingAllowOriginHeader":case"MultipleAllowOriginValues":case"InvalidAllowOriginValue":return"CorsIssue::InvalidHeaders";case"PreflightWildcardOriginNotAllowed":case"WildcardOriginNotAllowed":return"CorsIssue::WildcardOriginWithCredentials";case"PreflightInvalidStatus":case"PreflightDisallowedRedirect":case"InvalidResponse":return"CorsIssue::PreflightResponseInvalid";case"AllowOriginMismatch":case"PreflightAllowOriginMismatch":return"CorsIssue::OriginMismatch";case"InvalidAllowCredentials":case"PreflightInvalidAllowCredentials":return"CorsIssue::AllowCredentialsRequired";case"MethodDisallowedByPreflightResponse":return"CorsIssue::MethodDisallowedByPreflightResponse";case"HeaderDisallowedByPreflightResponse":return"CorsIssue::HeaderDisallowedByPreflightResponse";case"RedirectContainsCredentials":return"CorsIssue::RedirectContainsCredentials";case"DisallowedByMode":return"CorsIssue::DisallowedByMode";case"CorsDisabledScheme":return"CorsIssue::CorsDisabledScheme";case"PreflightMissingAllowExternal":return"CorsIssue::PreflightMissingAllowExternal";case"PreflightInvalidAllowExternal":return"CorsIssue::PreflightInvalidAllowExternal";case"InsecurePrivateNetwork":return"CorsIssue::InsecurePrivateNetwork";case"NoCorsRedirectModeNotFollow":return"CorsIssue::NoCorsRedirectModeNotFollow";case"InvalidPrivateNetworkAccess":return"CorsIssue::InvalidPrivateNetworkAccess";case"UnexpectedPrivateNetworkAccess":return"CorsIssue::UnexpectedPrivateNetworkAccess";case"PreflightMissingAllowPrivateNetwork":case"PreflightInvalidAllowPrivateNetwork":return"CorsIssue::PreflightAllowPrivateNetworkError";case"PreflightMissingPrivateNetworkAccessId":return"CorsIssue::PreflightMissingPrivateNetworkAccessId";case"PreflightMissingPrivateNetworkAccessName":return"CorsIssue::PreflightMissingPrivateNetworkAccessName";case"PrivateNetworkAccessPermissionUnavailable":return"CorsIssue::PrivateNetworkAccessPermissionUnavailable";case"PrivateNetworkAccessPermissionDenied":return"CorsIssue::PrivateNetworkAccessPermissionDenied";case"LocalNetworkAccessPermissionDenied":return"CorsIssue::LocalNetworkAccessPermissionDenied"}}class Ve extends g{#o;constructor(e,t,s){super(ze(e),t,s),this.#o=e}getCategory(){return"Cors"}details(){return this.#o}getDescription(){switch(ze(this.#o)){case"CorsIssue::InsecurePrivateNetwork":return{file:"corsInsecurePrivateNetwork.md",links:[{link:"https://developer.chrome.com/blog/private-network-access-update",linkTitle:Be(_e.corsPrivateNetworkAccess)}]};case"CorsIssue::PreflightAllowPrivateNetworkError":return{file:"corsPreflightAllowPrivateNetworkError.md",links:[{link:"https://developer.chrome.com/blog/private-network-access-update",linkTitle:Be(_e.corsPrivateNetworkAccess)}]};case"CorsIssue::InvalidHeaders":return{file:"corsInvalidHeaderValues.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Be(_e.CORS)}]};case"CorsIssue::WildcardOriginWithCredentials":return{file:"corsWildcardOriginNotAllowed.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Be(_e.CORS)}]};case"CorsIssue::PreflightResponseInvalid":return{file:"corsPreflightResponseInvalid.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Be(_e.CORS)}]};case"CorsIssue::OriginMismatch":return{file:"corsOriginMismatch.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Be(_e.CORS)}]};case"CorsIssue::AllowCredentialsRequired":return{file:"corsAllowCredentialsRequired.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Be(_e.CORS)}]};case"CorsIssue::MethodDisallowedByPreflightResponse":return{file:"corsMethodDisallowedByPreflightResponse.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Be(_e.CORS)}]};case"CorsIssue::HeaderDisallowedByPreflightResponse":return{file:"corsHeaderDisallowedByPreflightResponse.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Be(_e.CORS)}]};case"CorsIssue::RedirectContainsCredentials":return{file:"corsRedirectContainsCredentials.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Be(_e.CORS)}]};case"CorsIssue::DisallowedByMode":return{file:"corsDisallowedByMode.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Be(_e.CORS)}]};case"CorsIssue::CorsDisabledScheme":return{file:"corsDisabledScheme.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Be(_e.CORS)}]};case"CorsIssue::NoCorsRedirectModeNotFollow":return{file:"corsNoCorsRedirectModeNotFollow.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Be(_e.CORS)}]};case"CorsIssue::PreflightMissingPrivateNetworkAccessId":case"CorsIssue::PreflightMissingPrivateNetworkAccessName":return{file:"corsPrivateNetworkPermissionDenied.md",links:[{link:"https://developer.chrome.com/blog/private-network-access-update",linkTitle:Be(_e.corsPrivateNetworkAccess)}]};case"CorsIssue::LocalNetworkAccessPermissionDenied":return{file:"corsLocalNetworkAccessPermissionDenied.md",links:[{link:"https://chromestatus.com/feature/5152728072060928",linkTitle:Be(_e.corsLocalNetworkAccess)}]};case"CorsIssue::PreflightMissingAllowExternal":case"CorsIssue::PreflightInvalidAllowExternal":case"CorsIssue::InvalidPrivateNetworkAccess":case"CorsIssue::UnexpectedPrivateNetworkAccess":case"CorsIssue::PrivateNetworkAccessPermissionUnavailable":case"CorsIssue::PrivateNetworkAccessPermissionDenied":return null}}primaryKey(){return JSON.stringify(this.#o)}getKind(){return!this.#o.isWarning||"InsecurePrivateNetwork"!==this.#o.corsErrorStatus.corsError&&"PreflightMissingAllowPrivateNetwork"!==this.#o.corsErrorStatus.corsError&&"PreflightInvalidAllowPrivateNetwork"!==this.#o.corsErrorStatus.corsError?"PageError":"BreakingChange"}static fromInspectorIssue(e,t){const s=t.details.corsIssueDetails;return s?[new Ve(s,e,t.issueId)]:(console.warn("Cors issue without details received."),[])}}var je=Object.freeze({__proto__:null,CorsIssue:Ve});const Ke={coopAndCoep:"COOP and COEP",samesiteAndSameorigin:"Same-Site and Same-Origin"},$e=s.i18n.registerUIStrings("models/issues_manager/CrossOriginEmbedderPolicyIssue.ts",Ke),Ge=s.i18n.getLazilyComputedLocalizedString.bind(void 0,$e);function Je(e){switch(e){case"CoepFrameResourceNeedsCoepHeader":case"CoopSandboxedIFrameCannotNavigateToCoopPage":case"CorpNotSameOrigin":case"CorpNotSameOriginAfterDefaultedToSameOriginByCoep":case"CorpNotSameSite":return!0}return!1}class Qe extends g{#o;constructor(e,t){super(`CrossOriginEmbedderPolicyIssue::${e.reason}`,t),this.#o=e}primaryKey(){return`${this.code()}-(${this.#o.request.requestId})`}getBlockedByResponseDetails(){return[this.#o]}requests(){return[this.#o.request]}getCategory(){return"CrossOriginEmbedderPolicy"}getDescription(){const e=Ye.get(this.code());return e?S(e):null}getKind(){return"PageError"}}const Ye=new Map([["CrossOriginEmbedderPolicyIssue::CorpNotSameOriginAfterDefaultedToSameOriginByCoep",{file:"CoepCorpNotSameOriginAfterDefaultedToSameOriginByCoep.md",links:[{link:"https://web.dev/coop-coep/",linkTitle:Ge(Ke.coopAndCoep)},{link:"https://web.dev/same-site-same-origin/",linkTitle:Ge(Ke.samesiteAndSameorigin)}]}],["CrossOriginEmbedderPolicyIssue::CoepFrameResourceNeedsCoepHeader",{file:"CoepFrameResourceNeedsCoepHeader.md",links:[{link:"https://web.dev/coop-coep/",linkTitle:Ge(Ke.coopAndCoep)}]}],["CrossOriginEmbedderPolicyIssue::CoopSandboxedIframeCannotNavigateToCoopPage",{file:"CoepCoopSandboxedIframeCannotNavigateToCoopPage.md",links:[{link:"https://web.dev/coop-coep/",linkTitle:Ge(Ke.coopAndCoep)}]}],["CrossOriginEmbedderPolicyIssue::CorpNotSameSite",{file:"CoepCorpNotSameSite.md",links:[{link:"https://web.dev/coop-coep/",linkTitle:Ge(Ke.coopAndCoep)},{link:"https://web.dev/same-site-same-origin/",linkTitle:Ge(Ke.samesiteAndSameorigin)}]}],["CrossOriginEmbedderPolicyIssue::CorpNotSameOrigin",{file:"CoepCorpNotSameOrigin.md",links:[{link:"https://web.dev/coop-coep/",linkTitle:Ge(Ke.coopAndCoep)},{link:"https://web.dev/same-site-same-origin/",linkTitle:Ge(Ke.samesiteAndSameorigin)}]}]]);var Xe=Object.freeze({__proto__:null,CrossOriginEmbedderPolicyIssue:Qe,isCrossOriginEmbedderPolicyIssue:Je});const Ze={AuthorizationCoveredByWildcard:"Authorization will not be covered by the wildcard symbol (*) in CORS `Access-Control-Allow-Headers` handling.",CanRequestURLHTTPContainingNewline:"Resource requests whose URLs contained both removed whitespace `\\(n|r|t)` characters and less-than characters (`<`) are blocked. Please remove newlines and encode less-than characters from places like element attribute values in order to load these resources.",ChromeLoadTimesConnectionInfo:"`chrome.loadTimes()` is deprecated, instead use standardized API: Navigation Timing 2.",ChromeLoadTimesFirstPaintAfterLoadTime:"`chrome.loadTimes()` is deprecated, instead use standardized API: Paint Timing.",ChromeLoadTimesWasAlternateProtocolAvailable:"`chrome.loadTimes()` is deprecated, instead use standardized API: `nextHopProtocol` in Navigation Timing 2.",CookieWithTruncatingChar:"Cookies containing a `\\(0|r|n)` character will be rejected instead of truncated.",CrossOriginAccessBasedOnDocumentDomain:"Relaxing the same-origin policy by setting `document.domain` is deprecated, and will be disabled by default. This deprecation warning is for a cross-origin access that was enabled by setting `document.domain`.",CrossOriginWindowAlert:"Triggering window.alert from cross origin iframes has been deprecated and will be removed in the future.",CrossOriginWindowConfirm:"Triggering window.confirm from cross origin iframes has been deprecated and will be removed in the future.",CSSSelectorInternalMediaControlsOverlayCastButton:"The `disableRemotePlayback` attribute should be used in order to disable the default Cast integration instead of using `-internal-media-controls-overlay-cast-button` selector.",CSSValueAppearanceSliderVertical:"CSS appearance value `slider-vertical` is not standardized and will be removed.",DataUrlInSvgUse:"Support for data: URLs in SVGUseElement is deprecated and it will be removed in the future.",DOMMutationEvents:"DOM Mutation Events, including `DOMSubtreeModified`, `DOMNodeInserted`, `DOMNodeRemoved`, `DOMNodeRemovedFromDocument`, `DOMNodeInsertedIntoDocument`, and `DOMCharacterDataModified` are deprecated (https://w3c.github.io/uievents/#legacy-event-types) and will be removed. Please use `MutationObserver` instead.",GeolocationInsecureOrigin:"`getCurrentPosition()` and `watchPosition()` no longer work on insecure origins. To use this feature, you should consider switching your application to a secure origin, such as HTTPS. See https://goo.gle/chrome-insecure-origins for more details.",GeolocationInsecureOriginDeprecatedNotRemoved:"`getCurrentPosition()` and `watchPosition()` are deprecated on insecure origins. To use this feature, you should consider switching your application to a secure origin, such as HTTPS. See https://goo.gle/chrome-insecure-origins for more details.",GetUserMediaInsecureOrigin:"`getUserMedia()` no longer works on insecure origins. To use this feature, you should consider switching your application to a secure origin, such as HTTPS. See https://goo.gle/chrome-insecure-origins for more details.",H1UserAgentFontSizeInSection:"Found an <h1> tag within an <article>, <aside>, <nav>, or <section> which does not have a specified font-size. The size of this heading text will be changing in this browser in the near future. See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/Heading_Elements#specifying_a_uniform_font_size_for_h1 for more information.",HostCandidateAttributeGetter:"`RTCPeerConnectionIceErrorEvent.hostCandidate` is deprecated. Please use `RTCPeerConnectionIceErrorEvent.address` or `RTCPeerConnectionIceErrorEvent.port` instead.",IdentityDigitalCredentials:"This format for the navigator.credentials.get() request for digital credentials is deprecated, please update your call to use the new format.",IdentityInCanMakePaymentEvent:"The merchant origin and arbitrary data from the `canmakepayment` service worker event are deprecated and will be removed: `topOrigin`, `paymentRequestOrigin`, `methodData`, `modifiers`.",InsecurePrivateNetworkSubresourceRequest:"The website requested a subresource from a network that it could only access because of its users' privileged network position. These requests expose non-public devices and servers to the internet, increasing the risk of a cross-site request forgery (CSRF) attack, and/or information leakage. To mitigate these risks, Chrome deprecates requests to non-public subresources when initiated from non-secure contexts, and will start blocking them.",InterestGroupDailyUpdateUrl:"The `dailyUpdateUrl` field of `InterestGroups` passed to `joinAdInterestGroup()` has been renamed to `updateUrl`, to more accurately reflect its behavior.",IntlV8BreakIterator:"`Intl.v8BreakIterator` is deprecated. Please use `Intl.Segmenter` instead.",LocalCSSFileExtensionRejected:"CSS cannot be loaded from `file:` URLs unless they end in a `.css` file extension.",MediaSourceAbortRemove:"Using `SourceBuffer.abort()` to abort `remove()`'s asynchronous range removal is deprecated due to specification change. Support will be removed in the future. You should listen to the `updateend` event instead. `abort()` is intended to only abort an asynchronous media append or reset parser state.",MediaSourceDurationTruncatingBuffered:"Setting `MediaSource.duration` below the highest presentation timestamp of any buffered coded frames is deprecated due to specification change. Support for implicit removal of truncated buffered media will be removed in the future. You should instead perform explicit `remove(newDuration, oldDuration)` on all `sourceBuffers`, where `newDuration < oldDuration`.",NoSysexWebMIDIWithoutPermission:"Web MIDI will ask a permission to use even if the sysex is not specified in the `MIDIOptions`.",NotificationInsecureOrigin:"The Notification API may no longer be used from insecure origins. You should consider switching your application to a secure origin, such as HTTPS. See https://goo.gle/chrome-insecure-origins for more details.",NotificationPermissionRequestedIframe:"Permission for the Notification API may no longer be requested from a cross-origin iframe. You should consider requesting permission from a top-level frame or opening a new window instead.",ObsoleteCreateImageBitmapImageOrientationNone:"Option `imageOrientation: 'none'` in createImageBitmap is deprecated. Please use createImageBitmap with option '{imageOrientation: 'from-image'}' instead.",ObsoleteWebRtcCipherSuite:"Your partner is negotiating an obsolete (D)TLS version. Please check with your partner to have this fixed.",OverflowVisibleOnReplacedElement:"Specifying `overflow: visible` on img, video and canvas tags may cause them to produce visual content outside of the element bounds. See https://github.com/WICG/shared-element-transitions/blob/main/debugging_overflow_on_images.md.",PaymentInstruments:"`paymentManager.instruments` is deprecated. Please use just-in-time install for payment handlers instead.",PaymentRequestCSPViolation:"Your `PaymentRequest` call bypassed Content-Security-Policy (CSP) `connect-src` directive. This bypass is deprecated. Please add the payment method identifier from the `PaymentRequest` API (in `supportedMethods` field) to your CSP `connect-src` directive.",PersistentQuotaType:"`StorageType.persistent` is deprecated. Please use standardized `navigator.storage` instead.",PictureSourceSrc:"`<source src>` with a `<picture>` parent is invalid and therefore ignored. Please use `<source srcset>` instead.",PrefixedCancelAnimationFrame:"webkitCancelAnimationFrame is vendor-specific. Please use the standard cancelAnimationFrame instead.",PrefixedRequestAnimationFrame:"webkitRequestAnimationFrame is vendor-specific. Please use the standard requestAnimationFrame instead.",PrefixedVideoDisplayingFullscreen:"HTMLVideoElement.webkitDisplayingFullscreen is deprecated. Please use Document.fullscreenElement instead.",PrefixedVideoEnterFullScreen:"HTMLVideoElement.webkitEnterFullScreen() is deprecated. Please use Element.requestFullscreen() instead.",PrefixedVideoEnterFullscreen:"HTMLVideoElement.webkitEnterFullscreen() is deprecated. Please use Element.requestFullscreen() instead.",PrefixedVideoExitFullScreen:"HTMLVideoElement.webkitExitFullScreen() is deprecated. Please use Document.exitFullscreen() instead.",PrefixedVideoExitFullscreen:"HTMLVideoElement.webkitExitFullscreen() is deprecated. Please use Document.exitFullscreen() instead.",PrefixedVideoSupportsFullscreen:"HTMLVideoElement.webkitSupportsFullscreen is deprecated. Please use Document.fullscreenEnabled instead.",PrivacySandboxExtensionsAPI:"We're deprecating the API `chrome.privacy.websites.privacySandboxEnabled`, though it will remain active for backward compatibility until release M113. Instead, please use `chrome.privacy.websites.topicsEnabled`, `chrome.privacy.websites.fledgeEnabled` and `chrome.privacy.websites.adMeasurementEnabled`. See https://developer.chrome.com/docs/extensions/reference/privacy/#property-websites-privacySandboxEnabled.",RangeExpand:"Range.expand() is deprecated. Please use Selection.modify() instead.",RequestedSubresourceWithEmbeddedCredentials:"Subresource requests whose URLs contain embedded credentials (e.g. `https://user:pass@host/`) are blocked.",RTCConstraintEnableDtlsSrtpFalse:"The constraint `DtlsSrtpKeyAgreement` is removed. You have specified a `false` value for this constraint, which is interpreted as an attempt to use the removed `SDES key negotiation` method. This functionality is removed; use a service that supports `DTLS key negotiation` instead.",RTCConstraintEnableDtlsSrtpTrue:"The constraint `DtlsSrtpKeyAgreement` is removed. You have specified a `true` value for this constraint, which had no effect, but you can remove this constraint for tidiness.",RTCPeerConnectionGetStatsLegacyNonCompliant:"The callback-based getStats() is deprecated and will be removed. Use the spec-compliant getStats() instead.",RtcpMuxPolicyNegotiate:"The `rtcpMuxPolicy` option is deprecated and will be removed.",SharedArrayBufferConstructedWithoutIsolation:"`SharedArrayBuffer` will require cross-origin isolation. See https://developer.chrome.com/blog/enabling-shared-array-buffer/ for more details.",TextToSpeech_DisallowedByAutoplay:"`speechSynthesis.speak()` without user activation is deprecated and will be removed.",UnloadHandler:"Unload event listeners are deprecated and will be removed.",V8SharedArrayBufferConstructedInExtensionWithoutIsolation:"Extensions should opt into cross-origin isolation to continue using `SharedArrayBuffer`. See https://developer.chrome.com/docs/extensions/mv3/cross-origin-isolation/.",XHRJSONEncodingDetection:"UTF-16 is not supported by response json in `XMLHttpRequest`",XMLHttpRequestSynchronousInNonWorkerOutsideBeforeUnload:"Synchronous `XMLHttpRequest` on the main thread is deprecated because of its detrimental effects to the end user's experience. For more help, check https://xhr.spec.whatwg.org/."},et={AuthorizationCoveredByWildcard:{milestone:97},CSSSelectorInternalMediaControlsOverlayCastButton:{chromeStatusFeature:5714245488476160},CSSValueAppearanceSliderVertical:{chromeStatusFeature:6001359429566464},CanRequestURLHTTPContainingNewline:{chromeStatusFeature:5735596811091968},ChromeLoadTimesConnectionInfo:{chromeStatusFeature:5637885046816768},ChromeLoadTimesFirstPaintAfterLoadTime:{chromeStatusFeature:5637885046816768},ChromeLoadTimesWasAlternateProtocolAvailable:{chromeStatusFeature:5637885046816768},CookieWithTruncatingChar:{milestone:103},CrossOriginAccessBasedOnDocumentDomain:{milestone:115},DOMMutationEvents:{chromeStatusFeature:5083947249172480,milestone:127},DataUrlInSvgUse:{chromeStatusFeature:5128825141198848,milestone:119},H1UserAgentFontSizeInSection:{chromeStatusFeature:6192419898654720,milestone:136},IdentityDigitalCredentials:{chromeStatusFeature:5166035265650688},IdentityInCanMakePaymentEvent:{chromeStatusFeature:5190978431352832},InsecurePrivateNetworkSubresourceRequest:{chromeStatusFeature:5436853517811712,milestone:92},LocalCSSFileExtensionRejected:{milestone:64},MediaSourceAbortRemove:{chromeStatusFeature:6107495151960064},MediaSourceDurationTruncatingBuffered:{chromeStatusFeature:6107495151960064},NoSysexWebMIDIWithoutPermission:{chromeStatusFeature:5138066234671104,milestone:82},NotificationPermissionRequestedIframe:{chromeStatusFeature:6451284559265792},ObsoleteCreateImageBitmapImageOrientationNone:{milestone:111},ObsoleteWebRtcCipherSuite:{milestone:81},OverflowVisibleOnReplacedElement:{chromeStatusFeature:5137515594383360,milestone:108},PaymentInstruments:{chromeStatusFeature:5099285054488576},PaymentRequestCSPViolation:{chromeStatusFeature:6286595631087616},PersistentQuotaType:{chromeStatusFeature:5176235376246784,milestone:106},RTCConstraintEnableDtlsSrtpFalse:{milestone:97},RTCConstraintEnableDtlsSrtpTrue:{milestone:97},RTCPeerConnectionGetStatsLegacyNonCompliant:{chromeStatusFeature:4631626228695040,milestone:117},RequestedSubresourceWithEmbeddedCredentials:{chromeStatusFeature:5669008342777856},RtcpMuxPolicyNegotiate:{chromeStatusFeature:5654810086866944,milestone:62},SharedArrayBufferConstructedWithoutIsolation:{milestone:106},TextToSpeech_DisallowedByAutoplay:{chromeStatusFeature:5687444770914304,milestone:71},UnloadHandler:{chromeStatusFeature:5579556305502208},V8SharedArrayBufferConstructedInExtensionWithoutIsolation:{milestone:96},XHRJSONEncodingDetection:{milestone:93}},tt={feature:"Check the feature status page for more details.",milestone:"This change will go into effect with milestone {milestone}.",title:"Deprecated feature used"},st=s.i18n.registerUIStrings("models/issues_manager/DeprecationIssue.ts",tt),it=s.i18n.getLazilyComputedLocalizedString.bind(void 0,st),rt=s.i18n.registerUIStrings("generated/Deprecation.ts",Ze),ot=s.i18n.getLazilyComputedLocalizedString.bind(void 0,rt);class nt extends g{#o;constructor(e,t){super({code:["DeprecationIssue",e.type].join("::"),umaCode:"DeprecationIssue"},t),this.#o=e}getCategory(){return"Other"}details(){return this.#o}getDescription(){let e=()=>"";const t=Ze[this.#o.type];t&&(e=ot(t));const s=[],i=et[this.#o.type],r=i?.chromeStatusFeature??0;0!==r&&s.push({link:`https://chromestatus.com/feature/${r}`,linkTitle:it(tt.feature)});const o=i?.milestone??0;return 0!==o&&s.push({link:"https://chromiumdash.appspot.com/schedule",linkTitle:it(tt.milestone,{milestone:o})}),S({file:"deprecation.md",substitutions:new Map([["PLACEHOLDER_title",it(tt.title)],["PLACEHOLDER_message",e]]),links:s})}sources(){return this.#o.sourceCodeLocation?[this.#o.sourceCodeLocation]:[]}primaryKey(){return JSON.stringify(this.#o)}getKind(){return"BreakingChange"}static fromInspectorIssue(e,t){const s=t.details.deprecationIssueDetails;return s?[new nt(s,e)]:(console.warn("Deprecation issue without details received."),[])}}var at=Object.freeze({__proto__:null,DeprecationIssue:nt});const ut={fedCmUserInfo:"Federated Credential Management User Info API"},lt=s.i18n.registerUIStrings("models/issues_manager/FederatedAuthUserInfoRequestIssue.ts",ut),dt=s.i18n.getLazilyComputedLocalizedString.bind(void 0,lt);class ct extends g{#o;constructor(e,t){super({code:"FederatedAuthUserInfoRequestIssue",umaCode:["FederatedAuthUserInfoRequestIssue",e.federatedAuthUserInfoRequestIssueReason].join("::")},t),this.#o=e}getCategory(){return"Other"}details(){return this.#o}getDescription(){const e=gt.get(this.#o.federatedAuthUserInfoRequestIssueReason);return e?S(e):null}primaryKey(){return JSON.stringify(this.#o)}getKind(){return"PageError"}static fromInspectorIssue(e,t){const s=t.details.federatedAuthUserInfoRequestIssueDetails;return s?[new ct(s,e)]:(console.warn("Federated auth user info request issue without details received."),[])}}const gt=new Map([["NotSameOrigin",{file:"federatedAuthUserInfoRequestNotSameOrigin.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:dt(ut.fedCmUserInfo)}]}],["NotIframe",{file:"federatedAuthUserInfoRequestNotIframe.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:dt(ut.fedCmUserInfo)}]}],["NotPotentiallyTrustworthy",{file:"federatedAuthUserInfoRequestNotPotentiallyTrustworthy.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:dt(ut.fedCmUserInfo)}]}],["NoApiPermission",{file:"federatedAuthUserInfoRequestNoApiPermission.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:dt(ut.fedCmUserInfo)}]}],["NotSignedInWithIdp",{file:"federatedAuthUserInfoRequestNotSignedInWithIdp.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:dt(ut.fedCmUserInfo)}]}],["NoAccountSharingPermission",{file:"federatedAuthUserInfoRequestNoAccountSharingPermission.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:dt(ut.fedCmUserInfo)}]}],["InvalidConfigOrWellKnown",{file:"federatedAuthUserInfoRequestInvalidConfigOrWellKnown.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:dt(ut.fedCmUserInfo)}]}],["InvalidAccountsResponse",{file:"federatedAuthUserInfoRequestInvalidAccountsResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:dt(ut.fedCmUserInfo)}]}],["NoReturningUserFromFetchedAccounts",{file:"federatedAuthUserInfoRequestNoReturningUserFromFetchedAccounts.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:dt(ut.fedCmUserInfo)}]}]]);var ht=Object.freeze({__proto__:null,FederatedAuthUserInfoRequestIssue:ct});const mt={howDoesAutofillWorkPageTitle:"How does autofill work?",labelFormlementsPageTitle:"The label elements",inputFormElementPageTitle:"The form input element",autocompleteAttributePageTitle:"HTML attribute: autocomplete",corbExplainerPageTitle:"CORB explainer"},pt=s.i18n.registerUIStrings("models/issues_manager/GenericIssue.ts",mt),It=s.i18n.getLazilyComputedLocalizedString.bind(void 0,pt);class ft extends g{#o;constructor(e,t,s){super(["GenericIssue",e.errorType].join("::"),t,s),this.#o=e}requests(){return this.#o.request?[this.#o.request]:[]}getCategory(){return"Generic"}primaryKey(){const e=this.#o.request?this.#o.request.requestId:"no-request";return`${this.code()}-(${this.#o.frameId})-(${this.#o.violatingNodeId})-(${this.#o.violatingNodeAttribute})-(${e})`}getDescription(){const e=Et.get(this.#o.errorType);return e?S(e):null}details(){return this.#o}getKind(){return Pt.get(this.#o.errorType)||"Improvement"}static fromInspectorIssue(e,t){const s=t.details.genericIssueDetails;return s?[new ft(s,e,t.issueId)]:(console.warn("Generic issue without details received."),[])}}const kt={file:"genericFormLabelForNameError.md",links:[{link:"https://html.spec.whatwg.org/multipage/forms.html#attr-label-for",linkTitle:s.i18n.lockedLazyString("HTML Standard")}]},Ct={file:"genericFormInputWithNoLabelError.md",links:[]},yt={file:"genericFormAutocompleteAttributeEmptyError.md",links:[]},St={file:"genericFormDuplicateIdForInputError.md",links:[{link:"https://web.dev/learn/forms/autofill/#how-does-autofill-work",linkTitle:It(mt.howDoesAutofillWorkPageTitle)}]},bt={file:"genericFormAriaLabelledByToNonExistingId.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Element/label",linkTitle:It(mt.labelFormlementsPageTitle)}]},vt={file:"genericFormEmptyIdAndNameAttributesForInputError.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input",linkTitle:It(mt.inputFormElementPageTitle)}]},wt={file:"genericFormInputAssignedAutocompleteValueToIdOrNameAttributeError.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/autocomplete#values",linkTitle:It(mt.autocompleteAttributePageTitle)}]},Dt={file:"genericFormInputHasWrongButWellIntendedAutocompleteValueError.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/autocomplete#values",linkTitle:It(mt.autocompleteAttributePageTitle)}]},Rt={file:"genericFormLabelForMatchesNonExistingIdError.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Element/label",linkTitle:It(mt.labelFormlementsPageTitle)}]},Tt={file:"genericFormLabelHasNeitherForNorNestedInput.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Element/label",linkTitle:It(mt.labelFormlementsPageTitle)}]},At={file:"genericResponseWasBlockedByORB.md",links:[{link:"https://www.chromium.org/Home/chromium-security/corb-for-developers/",linkTitle:It(mt.corbExplainerPageTitle)}]},Et=new Map([["FormLabelForNameError",kt],["FormInputWithNoLabelError",Ct],["FormAutocompleteAttributeEmptyError",yt],["FormDuplicateIdForInputError",St],["FormAriaLabelledByToNonExistingId",bt],["FormEmptyIdAndNameAttributesForInputError",vt],["FormInputAssignedAutocompleteValueToIdOrNameAttributeError",wt],["FormLabelForMatchesNonExistingIdError",Rt],["FormLabelHasNeitherForNorNestedInput",Tt],["FormInputHasWrongButWellIntendedAutocompleteValueError",Dt],["ResponseWasBlockedByORB",At]]),Pt=new Map([["FormLabelForNameError","PageError"],["FormInputWithNoLabelError","Improvement"],["FormAutocompleteAttributeEmptyError","PageError"],["FormDuplicateIdForInputError","PageError"],["FormAriaLabelledByToNonExistingId","Improvement"],["FormEmptyIdAndNameAttributesForInputError","Improvement"],["FormInputAssignedAutocompleteValueToIdOrNameAttributeError","Improvement"],["FormLabelForMatchesNonExistingIdError","PageError"],["FormLabelHasNeitherForNorNestedInput","Improvement"],["FormInputHasWrongButWellIntendedAutocompleteValueError","Improvement"]]);var Mt=Object.freeze({__proto__:null,GenericIssue:ft,genericFormAriaLabelledByToNonExistingId:bt,genericFormAutocompleteAttributeEmptyError:yt,genericFormDuplicateIdForInputError:St,genericFormEmptyIdAndNameAttributesForInputError:vt,genericFormInputAssignedAutocompleteValueToIdOrNameAttributeError:wt,genericFormInputHasWrongButWellIntendedAutocompleteValue:Dt,genericFormInputWithNoLabelError:Ct,genericFormLabelForMatchesNonExistingIdError:Rt,genericFormLabelForNameError:kt,genericFormLabelHasNeitherForNorNestedInput:Tt,genericResponseWasBlockedbyORB:At});const Nt={handlingHeavyAdInterventions:"Handling Heavy Ad Interventions"},Ft=s.i18n.registerUIStrings("models/issues_manager/HeavyAdIssue.ts",Nt),Lt=s.i18n.getLocalizedString.bind(void 0,Ft);class xt extends g{#o;constructor(e,t){super({code:"HeavyAdIssue",umaCode:["HeavyAdIssue",e.reason].join("::")},t),this.#o=e}details(){return this.#o}primaryKey(){return`HeavyAdIssue-${JSON.stringify(this.#o)}`}getDescription(){return{file:"heavyAd.md",links:[{link:"https://developers.google.com/web/updates/2020/05/heavy-ad-interventions",linkTitle:Lt(Nt.handlingHeavyAdInterventions)}]}}getCategory(){return"HeavyAd"}getKind(){switch(this.#o.resolution){case"HeavyAdBlocked":return"PageError";case"HeavyAdWarning":return"BreakingChange"}}static fromInspectorIssue(e,t){const s=t.details.heavyAdIssueDetails;return s?[new xt(s,e)]:(console.warn("Heavy Ad issue without details received."),[])}}var Ot=Object.freeze({__proto__:null,HeavyAdIssue:xt});const Wt={bounceTrackingMitigations:"Bounce tracking mitigations"},Ht=s.i18n.registerUIStrings("models/issues_manager/BounceTrackingIssue.ts",Wt),Ut=s.i18n.getLocalizedString.bind(void 0,Ht);class _t extends g{#o;constructor(e,t){super("BounceTrackingIssue",t),this.#o=e}getCategory(){return"Other"}getDescription(){return{file:"bounceTrackingMitigations.md",links:[{link:"https://privacycg.github.io/nav-tracking-mitigations/#bounce-tracking-mitigations",linkTitle:Ut(Wt.bounceTrackingMitigations)}]}}details(){return this.#o}getKind(){return"BreakingChange"}primaryKey(){return JSON.stringify(this.#o)}trackingSites(){return this.#o.trackingSites?this.#o.trackingSites:[]}static fromInspectorIssue(e,t){const s=t.details.bounceTrackingIssueDetails;return s?[new _t(s,e)]:(console.warn("Bounce tracking issue without details received."),[])}}const qt={fedCm:"Federated Credential Management API"},Bt=s.i18n.registerUIStrings("models/issues_manager/FederatedAuthRequestIssue.ts",qt),zt=s.i18n.getLazilyComputedLocalizedString.bind(void 0,Bt);class Vt extends g{#o;constructor(e,t){super({code:"FederatedAuthRequestIssue",umaCode:["FederatedAuthRequestIssue",e.federatedAuthRequestIssueReason].join("::")},t),this.#o=e}getCategory(){return"Other"}details(){return this.#o}getDescription(){const e=jt.get(this.#o.federatedAuthRequestIssueReason);return e?S(e):null}primaryKey(){return JSON.stringify(this.#o)}getKind(){return"PageError"}static fromInspectorIssue(e,t){const s=t.details.federatedAuthRequestIssueDetails;return s?[new Vt(s,e)]:(console.warn("Federated auth request issue without details received."),[])}}const jt=new Map([["TooManyRequests",{file:"federatedAuthRequestTooManyRequests.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}],["ConfigHttpNotFound",{file:"federatedAuthRequestManifestHttpNotFound.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}],["ConfigNoResponse",{file:"federatedAuthRequestManifestNoResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}],["ConfigInvalidResponse",{file:"federatedAuthRequestManifestInvalidResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}],["ClientMetadataHttpNotFound",{file:"federatedAuthRequestClientMetadataHttpNotFound.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}],["ClientMetadataNoResponse",{file:"federatedAuthRequestClientMetadataNoResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}],["ClientMetadataInvalidResponse",{file:"federatedAuthRequestClientMetadataInvalidResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}],["ErrorFetchingSignin",{file:"federatedAuthRequestErrorFetchingSignin.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}],["InvalidSigninResponse",{file:"federatedAuthRequestInvalidSigninResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}],["AccountsHttpNotFound",{file:"federatedAuthRequestAccountsHttpNotFound.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}],["AccountsNoResponse",{file:"federatedAuthRequestAccountsNoResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}],["AccountsInvalidResponse",{file:"federatedAuthRequestAccountsInvalidResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}],["IdTokenHttpNotFound",{file:"federatedAuthRequestIdTokenHttpNotFound.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}],["IdTokenNoResponse",{file:"federatedAuthRequestIdTokenNoResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}],["IdTokenInvalidResponse",{file:"federatedAuthRequestIdTokenInvalidResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}],["IdTokenInvalidRequest",{file:"federatedAuthRequestIdTokenInvalidRequest.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}],["ErrorIdToken",{file:"federatedAuthRequestErrorIdToken.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}],["Canceled",{file:"federatedAuthRequestCanceled.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:zt(qt.fedCm)}]}]]),Kt={colorAndContrastAccessibility:"Color and contrast accessibility"},$t=s.i18n.registerUIStrings("models/issues_manager/LowTextContrastIssue.ts",Kt),Gt=s.i18n.getLocalizedString.bind(void 0,$t);class Jt extends g{#o;constructor(e,t){super("LowTextContrastIssue",t),this.#o=e}primaryKey(){return`${this.code()}-(${this.#o.violatingNodeId})`}getCategory(){return"LowTextContrast"}details(){return this.#o}getDescription(){return{file:"LowTextContrast.md",links:[{link:"https://web.dev/color-and-contrast-accessibility/",linkTitle:Gt(Kt.colorAndContrastAccessibility)}]}}getKind(){return"Improvement"}static fromInspectorIssue(e,t){const s=t.details.lowTextContrastIssueDetails;return s?[new Jt(s,e)]:(console.warn("LowTextContrast issue without details received."),[])}}var Qt=Object.freeze({__proto__:null,LowTextContrastIssue:Jt});const Yt={preventingMixedContent:"Preventing mixed content"},Xt=s.i18n.registerUIStrings("models/issues_manager/MixedContentIssue.ts",Yt),Zt=s.i18n.getLocalizedString.bind(void 0,Xt);class es extends g{#o;constructor(e,t){super("MixedContentIssue",t),this.#o=e}requests(){return this.#o.request?[this.#o.request]:[]}getDetails(){return this.#o}getCategory(){return"MixedContent"}getDescription(){return{file:"mixedContent.md",links:[{link:"https://web.dev/what-is-mixed-content/",linkTitle:Zt(Yt.preventingMixedContent)}]}}primaryKey(){return JSON.stringify(this.#o)}getKind(){switch(this.#o.resolutionStatus){case"MixedContentAutomaticallyUpgraded":case"MixedContentWarning":return"Improvement";case"MixedContentBlocked":return"PageError"}}static fromInspectorIssue(e,t){const s=t.details.mixedContentIssueDetails;return s?[new es(s,e)]:(console.warn("Mixed content issue without details received."),[])}}var ts=Object.freeze({__proto__:null,MixedContentIssue:es});const ss={partitioningBlobURL:"Partitioning BlobURL",chromeStatusEntry:"Chrome Status Entry"},is=s.i18n.registerUIStrings("models/issues_manager/PartitioningBlobURLIssue.ts",ss),rs=s.i18n.getLocalizedString.bind(void 0,is);class os extends g{#o;constructor(e,t){super("PartitioningBlobURLIssue",t),this.#o=e}getCategory(){return"Other"}getDescription(){return{file:"BlockedCrossPartitionFetching"===this.#o.partitioningBlobURLInfo?"fetchingPartitionedBlobURL.md":"navigatingPartitionedBlobURL.md",links:[{link:"https://developers.google.com/privacy-sandbox/cookies/storage-partitioning",linkTitle:rs(ss.partitioningBlobURL)},{link:"https://chromestatus.com/feature/5130361898795008",linkTitle:rs(ss.chromeStatusEntry)}]}}details(){return this.#o}getKind(){return"BreakingChange"}primaryKey(){return JSON.stringify(this.#o)}static fromInspectorIssue(e,t){const s=t.details.partitioningBlobURLIssueDetails;return s?[new os(s,e)]:(console.warn("Partitioning BlobURL issue without details received."),[])}}var ns=Object.freeze({__proto__:null,PartitioningBlobURLIssue:os});class as extends g{#o;#d;constructor(e,t){const s=JSON.stringify(e);super(s,t),this.#d=s,this.#o=e}sources(){return[this.#o.sourceCodeLocation]}details(){return this.#o}primaryKey(){return this.#d}getPropertyName(){switch(this.#o.propertyRuleIssueReason){case"InvalidInherits":return"inherits";case"InvalidInitialValue":return"initial-value";case"InvalidSyntax":return"syntax"}return""}getDescription(){if("InvalidName"===this.#o.propertyRuleIssueReason)return{file:"propertyRuleInvalidNameIssue.md",links:[]};const e=this.#o.propertyValue?`: ${this.#o.propertyValue}`:"",t=`${this.getPropertyName()}${e}`;return{file:"propertyRuleIssue.md",substitutions:new Map([["PLACEHOLDER_property",t]]),links:[]}}getCategory(){return"Other"}getKind(){return"PageError"}static fromInspectorIssue(e,t){const s=t.details.propertyRuleIssueDetails;return s?[new as(s,e)]:(console.warn("Property rule issue without details received"),[])}}var us=Object.freeze({__proto__:null,PropertyRuleIssue:as});const ls={documentCompatibilityMode:"Document compatibility mode"},ds=s.i18n.registerUIStrings("models/issues_manager/QuirksModeIssue.ts",ls),cs=s.i18n.getLocalizedString.bind(void 0,ds);class gs extends g{#o;constructor(e,t){super({code:"QuirksModeIssue",umaCode:["QuirksModeIssue",e.isLimitedQuirksMode?"LimitedQuirksMode":"QuirksMode"].join("::")},t),this.#o=e}primaryKey(){return`${this.code()}-(${this.#o.documentNodeId})-(${this.#o.url})`}getCategory(){return"QuirksMode"}details(){return this.#o}getDescription(){return{file:"CompatibilityModeQuirks.md",links:[{link:"https://web.dev/doctype/",linkTitle:cs(ls.documentCompatibilityMode)}]}}getKind(){return"Improvement"}static fromInspectorIssue(e,t){const s=t.details.quirksModeIssueDetails;return s?[new gs(s,e)]:(console.warn("Quirks Mode issue without details received."),[])}}var hs=Object.freeze({__proto__:null,QuirksModeIssue:gs});class ms extends g{issueDetails;constructor(e,t,s){super(["SelectElementAccessibilityIssue",e.selectElementAccessibilityIssueReason].join("::"),t,s),this.issueDetails=e}primaryKey(){return JSON.stringify(this.issueDetails)}getDescription(){if(this.isInteractiveContentAttributesSelectDescendantIssue())return{file:"selectElementAccessibilityInteractiveContentAttributesSelectDescendant.md",links:[]};const e=ps.get(this.issueDetails.selectElementAccessibilityIssueReason);return e?S(e):null}getKind(){return"PageError"}getCategory(){return"Other"}details(){return this.issueDetails}isInteractiveContentAttributesSelectDescendantIssue(){return this.issueDetails.hasDisallowedAttributes&&"InteractiveContentOptionChild"!==this.issueDetails.selectElementAccessibilityIssueReason}static fromInspectorIssue(e,t){const s=t.details.selectElementAccessibilityIssueDetails;return s?[new ms(s,e,t.issueId)]:(console.warn("Select Element Accessibility issue without details received."),[])}}const ps=new Map([["DisallowedSelectChild",{file:"selectElementAccessibilityDisallowedSelectChild.md",links:[]}],["DisallowedOptGroupChild",{file:"selectElementAccessibilityDisallowedOptGroupChild.md",links:[]}],["NonPhrasingContentOptionChild",{file:"selectElementAccessibilityNonPhrasingContentOptionChild.md",links:[]}],["InteractiveContentOptionChild",{file:"selectElementAccessibilityInteractiveContentOptionChild.md",links:[]}],["InteractiveContentLegendChild",{file:"selectElementAccessibilityInteractiveContentLegendChild.md",links:[]}]]);var Is=Object.freeze({__proto__:null,SelectElementAccessibilityIssue:ms});const fs={enablingSharedArrayBuffer:"Enabling `SharedArrayBuffer`"},ks=s.i18n.registerUIStrings("models/issues_manager/SharedArrayBufferIssue.ts",fs),Cs=s.i18n.getLocalizedString.bind(void 0,ks);class ys extends g{#o;constructor(e,t){super({code:"SharedArrayBufferIssue",umaCode:["SharedArrayBufferIssue",e.type].join("::")},t),this.#o=e}getCategory(){return"Other"}details(){return this.#o}getDescription(){return{file:"sharedArrayBuffer.md",links:[{link:"https://developer.chrome.com/blog/enabling-shared-array-buffer/",linkTitle:Cs(fs.enablingSharedArrayBuffer)}]}}primaryKey(){return JSON.stringify(this.#o)}getKind(){return this.#o.isWarning?"BreakingChange":"PageError"}static fromInspectorIssue(e,t){const s=t.details.sharedArrayBufferIssueDetails;return s?[new ys(s,e)]:(console.warn("SAB transfer issue without details received."),[])}}var Ss=Object.freeze({__proto__:null,SharedArrayBufferIssue:ys});const bs={compressionDictionaryTransport:"Compression Dictionary Transport"},vs=s.i18n.registerUIStrings("models/issues_manager/SharedDictionaryIssue.ts",bs),ws=s.i18n.getLazilyComputedLocalizedString.bind(void 0,vs);function Ds(e){switch(e.sharedDictionaryError){case"UseErrorCrossOriginNoCorsRequest":return"SharedDictionaryIssue::UseErrorCrossOriginNoCorsRequest";case"UseErrorDictionaryLoadFailure":return"SharedDictionaryIssue::UseErrorDictionaryLoadFailure";case"UseErrorMatchingDictionaryNotUsed":return"SharedDictionaryIssue::UseErrorMatchingDictionaryNotUsed";case"UseErrorUnexpectedContentDictionaryHeader":return"SharedDictionaryIssue::UseErrorUnexpectedContentDictionaryHeader";case"WriteErrorCossOriginNoCorsRequest":return"SharedDictionaryIssue::WriteErrorCossOriginNoCorsRequest";case"WriteErrorDisallowedBySettings":return"SharedDictionaryIssue::WriteErrorDisallowedBySettings";case"WriteErrorExpiredResponse":return"SharedDictionaryIssue::WriteErrorExpiredResponse";case"WriteErrorFeatureDisabled":return"SharedDictionaryIssue::WriteErrorFeatureDisabled";case"WriteErrorInsufficientResources":return"SharedDictionaryIssue::WriteErrorInsufficientResources";case"WriteErrorInvalidMatchField":return"SharedDictionaryIssue::WriteErrorInvalidMatchField";case"WriteErrorInvalidStructuredHeader":return"SharedDictionaryIssue::WriteErrorInvalidStructuredHeader";case"WriteErrorNavigationRequest":return"SharedDictionaryIssue::WriteErrorNavigationRequest";case"WriteErrorNoMatchField":return"SharedDictionaryIssue::WriteErrorNoMatchField";case"WriteErrorNonListMatchDestField":return"SharedDictionaryIssue::WriteErrorNonListMatchDestField";case"WriteErrorNonSecureContext":return"SharedDictionaryIssue::WriteErrorNonSecureContext";case"WriteErrorNonStringIdField":return"SharedDictionaryIssue::WriteErrorNonStringIdField";case"WriteErrorNonStringInMatchDestList":return"SharedDictionaryIssue::WriteErrorNonStringInMatchDestList";case"WriteErrorNonStringMatchField":return"SharedDictionaryIssue::WriteErrorNonStringMatchField";case"WriteErrorNonTokenTypeField":return"SharedDictionaryIssue::WriteErrorNonTokenTypeField";case"WriteErrorRequestAborted":return"SharedDictionaryIssue::WriteErrorRequestAborted";case"WriteErrorShuttingDown":return"SharedDictionaryIssue::WriteErrorShuttingDown";case"WriteErrorTooLongIdField":return"SharedDictionaryIssue::WriteErrorTooLongIdField";case"WriteErrorUnsupportedType":return"SharedDictionaryIssue::WriteErrorUnsupportedType";default:return"SharedDictionaryIssue::WriteErrorUnknown"}}class Rs extends g{#o;constructor(e,t){super({code:Ds(e),umaCode:["SharedDictionaryIssue",e.sharedDictionaryError].join("::")},t),this.#o=e}requests(){return this.#o.request?[this.#o.request]:[]}getCategory(){return"Other"}details(){return this.#o}getDescription(){const e=As.get(this.#o.sharedDictionaryError);return e?S(e):null}primaryKey(){return JSON.stringify(this.#o)}getKind(){return"PageError"}static fromInspectorIssue(e,t){const s=t.details.sharedDictionaryIssueDetails;return s?[new Rs(s,e)]:(console.warn("Shared Dictionary issue without details received."),[])}}const Ts=[{link:"https://datatracker.ietf.org/doc/draft-ietf-httpbis-compression-dictionary/",linkTitle:ws(bs.compressionDictionaryTransport)}],As=new Map([["UseErrorCrossOriginNoCorsRequest",{file:"sharedDictionaryUseErrorCrossOriginNoCorsRequest.md",links:Ts}],["UseErrorDictionaryLoadFailure",{file:"sharedDictionaryUseErrorDictionaryLoadFailure.md",links:Ts}],["UseErrorMatchingDictionaryNotUsed",{file:"sharedDictionaryUseErrorMatchingDictionaryNotUsed.md",links:Ts}],["UseErrorUnexpectedContentDictionaryHeader",{file:"sharedDictionaryUseErrorUnexpectedContentDictionaryHeader.md",links:Ts}],["WriteErrorCossOriginNoCorsRequest",{file:"sharedDictionaryWriteErrorCossOriginNoCorsRequest.md",links:Ts}],["WriteErrorDisallowedBySettings",{file:"sharedDictionaryWriteErrorDisallowedBySettings.md",links:Ts}],["WriteErrorExpiredResponse",{file:"sharedDictionaryWriteErrorExpiredResponse.md",links:Ts}],["WriteErrorFeatureDisabled",{file:"sharedDictionaryWriteErrorFeatureDisabled.md",links:Ts}],["WriteErrorInsufficientResources",{file:"sharedDictionaryWriteErrorInsufficientResources.md",links:Ts}],["WriteErrorInvalidMatchField",{file:"sharedDictionaryWriteErrorInvalidMatchField.md",links:Ts}],["WriteErrorInvalidStructuredHeader",{file:"sharedDictionaryWriteErrorInvalidStructuredHeader.md",links:Ts}],["WriteErrorNavigationRequest",{file:"sharedDictionaryWriteErrorNavigationRequest.md",links:Ts}],["WriteErrorNoMatchField",{file:"sharedDictionaryWriteErrorNoMatchField.md",links:Ts}],["WriteErrorNonListMatchDestField",{file:"sharedDictionaryWriteErrorNonListMatchDestField.md",links:Ts}],["WriteErrorNonSecureContext",{file:"sharedDictionaryWriteErrorNonSecureContext.md",links:Ts}],["WriteErrorNonStringIdField",{file:"sharedDictionaryWriteErrorNonStringIdField.md",links:Ts}],["WriteErrorNonStringInMatchDestList",{file:"sharedDictionaryWriteErrorNonStringInMatchDestList.md",links:Ts}],["WriteErrorNonStringMatchField",{file:"sharedDictionaryWriteErrorNonStringMatchField.md",links:Ts}],["WriteErrorNonTokenTypeField",{file:"sharedDictionaryWriteErrorNonTokenTypeField.md",links:Ts}],["WriteErrorRequestAborted",{file:"sharedDictionaryWriteErrorRequestAborted.md",links:Ts}],["WriteErrorShuttingDown",{file:"sharedDictionaryWriteErrorShuttingDown.md",links:Ts}],["WriteErrorTooLongIdField",{file:"sharedDictionaryWriteErrorTooLongIdField.md",links:Ts}],["WriteErrorUnsupportedType",{file:"sharedDictionaryWriteErrorUnsupportedType.md",links:Ts}]]);var Es=Object.freeze({__proto__:null,SharedDictionaryIssue:Rs});const Ps=["StylesheetLoadingIssue","LateImportRule"].join("::");class Ms extends g{#o;constructor(e,t){super(`StylesheetLoadingIssue::${e.styleSheetLoadingIssueReason}`,t),this.#o=e}sources(){return[this.#o.sourceCodeLocation]}requests(){if(!this.#o.failedRequestInfo)return[];const{url:e,requestId:t}=this.#o.failedRequestInfo;return t?[{url:e,requestId:t}]:[]}details(){return this.#o}primaryKey(){return JSON.stringify(this.#o)}getDescription(){switch(this.#o.styleSheetLoadingIssueReason){case"LateImportRule":return{file:"stylesheetLateImport.md",links:[]};case"RequestFailed":return{file:"stylesheetRequestFailed.md",links:[]}}}getCategory(){return"Other"}getKind(){return"PageError"}static fromInspectorIssue(e,t){const s=t.details.stylesheetLoadingIssueDetails;return s?[new Ms(s,e)]:(console.warn("Stylesheet loading issue without details received"),[])}}var Ns=Object.freeze({__proto__:null,StylesheetLoadingIssue:Ms,lateImportStylesheetLoadingCode:Ps});class Fs{issuesManager;#c=new a.PresentationConsoleMessageHelper.PresentationSourceFrameMessageManager;constructor(e){this.issuesManager=e,this.issuesManager.addEventListener("IssueAdded",this.#g,this),this.issuesManager.addEventListener("FullUpdateRequired",this.#h,this)}#g(e){const{issue:t}=e.data;this.#m(t)}async#m(t){if(!this.#p(t)&&!this.#I(t)&&!this.#f(t))return;const s=t.model();if(!s)return;const i=h(t.details().sourceCodeLocation),r=t.getDescription();if(!r||!i)return;const o=await E(r);if(!o)return;this.#c.addMessage(new Ls(o,t.getKind(),(()=>{e.Revealer.reveal(t)})),{line:i.lineNumber,column:i.columnNumber??-1,url:i.url,scriptId:i.scriptId},s.target())}#h(){this.#k();const e=this.issuesManager.issues();for(const t of e)this.#m(t)}#p(e){return e instanceof _&&e.code()===J||e.code()===Q}#f(e){return e instanceof as}#I(e){return e.code()===Ps}#k(){this.#c.clear()}}class Ls extends u.UISourceCode.Message{#C;constructor(e,t,s){super("Issue",e,s),this.#C=t}getIssueKind(){return this.#C}}var xs=Object.freeze({__proto__:null,IssueMessage:Ls,SourceFrameIssuesManager:Fs});const Os={httpMessageSignatures:"HTTP Message Signatures (RFC9421)",signatureBasedIntegrity:"Signature-based Integrity"},Ws=s.i18n.registerUIStrings("models/issues_manager/SRIMessageSignatureIssue.ts",Os),Hs=s.i18n.getLazilyComputedLocalizedString.bind(void 0,Ws);function Us(e){const t=`SRIMessageSignatureIssue::${e.error}`;return"ValidationFailedSignatureMismatch"===e.error?t+e.signatureBase:"ValidationFailedIntegrityMismatch"===e.error?t+e.integrityAssertions.join():t}class _s extends g{#o;constructor(e,t){super({code:Us(e),umaCode:`SRIMessageSignatureIssue::${e.error}`},t),this.#o=e}details(){return this.#o}primaryKey(){return JSON.stringify(this.details())}getDescription(){const e={file:`sri${this.details().error}.md`,links:[{link:"https://www.rfc-editor.org/rfc/rfc9421.html",linkTitle:Hs(Os.httpMessageSignatures)},{link:"https://wicg.github.io/signature-based-sri/",linkTitle:Hs(Os.signatureBasedIntegrity)}],substitutions:new Map};return"ValidationFailedSignatureMismatch"===this.#o.error&&e.substitutions?.set("PLACEHOLDER_signatureBase",(()=>this.#o.signatureBase)),"ValidationFailedIntegrityMismatch"===this.#o.error&&e.substitutions?.set("PLACEHOLDER_integrityAssertions",(()=>{const e="\n<li>";return e+this.details().integrityAssertions.join(e)})),S(e)}getCategory(){return"Other"}getKind(){return"PageError"}requests(){return this.details().request?[this.details().request]:[]}static fromInspectorIssue(e,t){const s=t.details.sriMessageSignatureIssueDetails;return s?[new _s(s,e)]:(console.warn("SRI Message Signature issue without details received."),[])}}var qs=Object.freeze({__proto__:null,SRIMessageSignatureIssue:_s});let Bs=null;const zs=new Map([["CookieIssue",de.fromInspectorIssue],["MixedContentIssue",es.fromInspectorIssue],["HeavyAdIssue",xt.fromInspectorIssue],["ContentSecurityPolicyIssue",_.fromInspectorIssue],["BlockedByResponseIssue",function(e,t){const s=t.details.blockedByResponseIssueDetails;return s?Je(s.reason)?[new Qe(s,e)]:[]:(console.warn("BlockedByResponse issue without details received."),[])}],["SharedArrayBufferIssue",ys.fromInspectorIssue],["SharedDictionaryIssue",Rs.fromInspectorIssue],["LowTextContrastIssue",Jt.fromInspectorIssue],["CorsIssue",Ve.fromInspectorIssue],["QuirksModeIssue",gs.fromInspectorIssue],["AttributionReportingIssue",I.fromInspectorIssue],["GenericIssue",ft.fromInspectorIssue],["DeprecationIssue",nt.fromInspectorIssue],["ClientHintIssue",L.fromInspectorIssue],["FederatedAuthRequestIssue",Vt.fromInspectorIssue],["BounceTrackingIssue",_t.fromInspectorIssue],["StylesheetLoadingIssue",Ms.fromInspectorIssue],["PartitioningBlobURLIssue",os.fromInspectorIssue],["PropertyRuleIssue",as.fromInspectorIssue],["CookieDeprecationMetadataIssue",oe.fromInspectorIssue],["SelectElementAccessibilityIssue",ms.fromInspectorIssue],["SRIMessageSignatureIssue",_s.fromInspectorIssue]]);function Vs(e,t){const s=zs.get(t.code);return s?s(e,t):(console.warn(`No handler registered for issue code ${t.code}`),[])}function js(){return{}}class Ks extends e.ObjectWrapper.ObjectWrapper{showThirdPartyIssuesSetting;hideIssueSetting;#y=new WeakMap;#S=new Map;#b=new Map;#v=new Map;#w=new Map;#D=new Map;#R=new Map;#T=!1;constructor(e,t){super(),this.showThirdPartyIssuesSetting=e,this.hideIssueSetting=t,new Fs(this),i.TargetManager.TargetManager.instance().observeModels(i.IssuesModel.IssuesModel,this),i.TargetManager.TargetManager.instance().addModelListener(i.ResourceTreeModel.ResourceTreeModel,i.ResourceTreeModel.Events.PrimaryPageChanged,this.#A,this),i.FrameManager.FrameManager.instance().addEventListener("FrameAddedToTarget",this.#E,this),this.showThirdPartyIssuesSetting?.addChangeListener((()=>this.#P())),this.hideIssueSetting?.addChangeListener((()=>this.#P())),i.TargetManager.TargetManager.instance().observeTargets({targetAdded:e=>{e.outermostTarget()===e&&this.#P()},targetRemoved:e=>{}},{scoped:!0})}static instance(e={forceNew:!1,ensureFirst:!1}){if(Bs&&e.ensureFirst)throw new Error('IssuesManager was already created. Either set "ensureFirst" to false or make sure that this invocation is really the first one.');return Bs&&!e.forceNew||(Bs=new Ks(e.showThirdPartyIssuesSetting,e.hideIssueSetting)),Bs}static removeInstance(){Bs=null}#A(e){const{frame:t,type:s}=e.data,r=new Map;for(const[e,o]of this.#S.entries())if(o.isAssociatedWithRequestId(t.loaderId))r.set(e,o);else if("Activation"===s&&t.resourceTreeModel().target()===o.model()?.target())r.set(e,o);else if("BounceTrackingIssue"===o.code()||"CookieIssue"===o.code()){const s=t.resourceTreeModel().target().model(i.NetworkManager.NetworkManager);!1===s?.requestForLoaderId(t.loaderId)?.hasUserGesture()&&r.set(e,o)}this.#S=r,this.#P()}#E(e){const{frame:t}=e.data;t.isOutermostFrame()&&i.TargetManager.TargetManager.instance().isInScope(t.resourceTreeModel())&&this.#P()}modelAdded(e){const t=e.addEventListener("IssueAdded",this.#M,this);this.#y.set(e,t)}modelRemoved(t){const s=this.#y.get(t);s&&e.EventTarget.removeEventListeners([s])}#M(e){const{issuesModel:t,inspectorIssue:s}=e.data,r=o.Runtime.hostConfig.devToolsPrivacyUI?.enabled,n=Vs(t,s);for(const e of n){this.addIssue(t,e);const s=e.maybeCreateConsoleMessage();if(!s)continue;const o="ThirdPartyPhaseoutCookie"===de.getSubCategory(e.code());o&&r&&this.#T||t.target().model(i.ConsoleModel.ConsoleModel)?.addMessage(s),o&&r&&(this.#T=!0)}}addIssue(e,t){if(!t.getDescription())return;const s=t.primaryKey();if(this.#S.has(s))return;this.#S.set(s,t);const i=e.target().outermostTarget();if(i){let e=this.#R.get(i);e||(e=new Set,this.#R.set(i,e)),e.add(t)}if(this.#N(t)){this.#b.set(s,t),this.#v.set(t.getKind(),1+(this.#v.get(t.getKind())||0));const i=t.getIssueId();i&&this.#D.set(i,t);const r=this.hideIssueSetting?.get();this.#F(t,r),t.isHidden()&&this.#w.set(t.getKind(),1+(this.#w.get(t.getKind())||0)),this.dispatchEventToListeners("IssueAdded",{issuesModel:e,issue:t})}this.dispatchEventToListeners("IssuesCountUpdated")}issues(){return this.#b.values()}numberOfIssues(e){return e?(this.#v.get(e)??0)-this.numberOfHiddenIssues(e):this.#b.size-this.numberOfHiddenIssues()}numberOfHiddenIssues(e){if(e)return this.#w.get(e)??0;let t=0;for(const e of this.#w.values())t+=e;return t}numberOfAllStoredIssues(){return this.#S.size}#N(e){const t=i.TargetManager.TargetManager.instance().scopeTarget();return!!t&&(!!this.#R.get(t)?.has(e)&&(this.showThirdPartyIssuesSetting?.get()||!e.isCausedByThirdParty()))}#F(e,t){const s=e.code();if(t?.[s])return"Hidden"===t[s]?void e.setHidden(!0):void e.setHidden(!1)}#P(){this.#b.clear(),this.#v.clear(),this.#D.clear(),this.#w.clear(),this.#T=!1;const e=this.hideIssueSetting?.get();for(const[t,s]of this.#S)if(this.#N(s)){this.#F(s,e),this.#b.set(t,s),this.#v.set(s.getKind(),1+(this.#v.get(s.getKind())??0)),s.isHidden()&&this.#w.set(s.getKind(),1+(this.#w.get(s.getKind())||0));const i=s.getIssueId();i&&this.#D.set(i,s)}this.dispatchEventToListeners("FullUpdateRequired"),this.dispatchEventToListeners("IssuesCountUpdated")}unhideAllIssues(){for(const e of this.#S.values())e.setHidden(!1);this.hideIssueSetting?.set({})}getIssueById(e){return this.#D.get(e)}}globalThis.addIssueForTest=e=>{const t=i.TargetManager.TargetManager.instance().primaryPageTarget(),s=t?.model(i.IssuesModel.IssuesModel);s?.issueAdded({issue:e})};var $s=Object.freeze({__proto__:null,IssuesManager:Ks,createIssuesFromProtocolIssue:Vs,defaultHideIssueByCodeSetting:js,getHideIssueByCodeSetting:function(){return e.Settings.Settings.instance().createSetting("hide-issue-by-code-setting-experiment-2021",{})}});class Gs extends e.ResolverBase.ResolverBase{#L=null;#x;constructor(e=Ks.instance()){super(),this.#x=e}getForId(e){return this.#x.getIssueById(e)||null}#g(e){const{issue:t}=e.data,s=t.getIssueId();s&&this.onResolve(s,t)}startListening(){this.#L||(this.#L=this.#x.addEventListener("IssueAdded",this.#g,this))}stopListening(){this.#L&&(e.EventTarget.removeEventListeners([this.#L]),this.#L=null)}}var Js=Object.freeze({__proto__:null,IssueResolver:Gs});function Qs(e,t){if(t instanceof i.NetworkRequest.NetworkRequest)return function(e,t){return e.filter((e=>{for(const s of e.requests())if(s.requestId===t.requestId())return!0;return!1}))}(e,t);if(t instanceof i.Cookie.Cookie)return function(e,t,s,i){return e.filter((e=>{for(const r of e.cookies())if(r.domain===t&&r.name===s&&r.path===i)return!0;return!1}))}(e,t.domain(),t.name(),t.path());throw new Error(`issues can not be associated with ${JSON.stringify(t)}`)}var Ys=Object.freeze({__proto__:null,hasIssueOfCategory:function(e,t){return Qs(Array.from(Ks.instance().issues()),e).some((e=>e.getCategory()===t))},hasIssues:function(e){return Qs(Array.from(Ks.instance().issues()),e).length>0},hasThirdPartyPhaseoutCookieIssue:function(e){return Qs(Array.from(Ks.instance().issues()),e).some((e=>"ThirdPartyPhaseoutCookie"===de.getSubCategory(e.code())))},hasThirdPartyPhaseoutCookieIssueForDomain:function(e){return Array.from(Ks.instance().issues()).filter((t=>Array.from(t.cookies()).some((t=>t.domain===e)))).some((e=>"ThirdPartyPhaseoutCookie"===de.getSubCategory(e.code())))},issuesAssociatedWith:Qs,reveal:async function(t,s){if("string"==typeof t){const s=Ks.instance().getIssueById(t);if(s)return await e.Revealer.reveal(s)}const i=Qs(Array.from(Ks.instance().issues()),t).filter((e=>!s||e.getCategory()===s));if(i.length>0)return await e.Revealer.reveal(i[0])}});export{f as AttributionReportingIssue,y as CheckFormsIssuesTrigger,O as ClientHintIssue,X as ContentSecurityPolicyIssue,te as ContrastCheckTrigger,ne as CookieDeprecationMetadataIssue,Ue as CookieIssue,je as CorsIssue,Xe as CrossOriginEmbedderPolicyIssue,at as DeprecationIssue,ht as FederatedAuthUserInfoRequestIssue,Mt as GenericIssue,Ot as HeavyAdIssue,m as Issue,Js as IssueResolver,$s as IssuesManager,Qt as LowTextContrastIssue,P as MarkdownIssueDescription,ts as MixedContentIssue,ns as PartitioningBlobURLIssue,us as PropertyRuleIssue,hs as QuirksModeIssue,Ys as RelatedIssue,qs as SRIMessageSignatureIssue,Is as SelectElementAccessibilityIssue,Ss as SharedArrayBufferIssue,Es as SharedDictionaryIssue,xs as SourceFrameIssuesManager,Ns as StylesheetLoadingIssue};
