class Chat{constructor({sidebarSelector:e="#chat-sidebar",sidebarContactAttribute:t="data-chat-id",sidebarContactSelector:s=`[${t}]`,searchSelector:a="[data-chat-search]",contentSelector:r="[data-chat]",inputSelector:i="[data-chat-input]",sendSelector:o="[data-send]",errorSelector:m="[data-error]",usernameSelector:n="[data-chat-username]",data:u=[]}={}){this.sidebar=document.querySelector(e),this.sidebarContactAttribute=t,this.sidebarContactSelector=s,this.searchInput=document.querySelector(a),this.chatContent=document.querySelector(r),this.chatInput=document.querySelector(i),this.sendButton=document.querySelector(o),this.errorElement=document.querySelector(m),this.usernameElement=document.querySelector(n),this.activeChatId=null,this.chatData=Array.isArray(u)?u:[],this.requiredElements=[{element:this.chatContent,name:"Chat content"},{element:this.chatInput,name:"Chat input"},{element:this.sendButton,name:"Send button"}],this.init()}showError(e,t=3e3){this.errorElement?(this.errorElement.textContent=e,this.errorElement.classList.remove("d-none"),this.errorElement.classList.add("d-block"),this.errorTimeout&&clearTimeout(this.errorTimeout),this.errorTimeout=setTimeout(()=>{this.errorElement.classList.remove("d-block"),this.errorElement.classList.add("d-none")},t)):console.error("Error element not found:",e)}checkRequiredElements(){var e=this.requiredElements.filter(e=>!e.element).map(e=>e.name);return!(0<e.length&&(e=`Missing required elements: ${e.join(", ")}. Please check your HTML structure.`,this.showError(e,1e4),console.error(e),1))}init(){var e,t;this.checkRequiredElements()&&(e=this.chatData[0],this.setupSearch(),this.sidebar&&(this.sidebar.addEventListener("click",e=>{e=e.target.closest(this.sidebarContactSelector);e&&e.dataset.chatId&&this.switchChat(e.dataset.chatId,e)}),e)&&((t=this.sidebar.querySelector(`[${this.sidebarContactAttribute}="${e.id}"]`))?this.switchChat(e.id,t):console.warn(`Default chat element with ID ${e.id} not found in sidebar`)),this.sendButton.addEventListener("click",()=>this.sendMessage()),this.chatInput.addEventListener("keypress",e=>{"Enter"===e.key&&(e.preventDefault(),this.sendMessage())}),this.chatInput.addEventListener("input",()=>{var e=this.chatInput.value.trim();this.sendButton.disabled=!e,this.errorElement&&e&&(this.errorElement.classList.remove("d-block"),this.errorElement.classList.add("d-none"),this.errorTimeout)&&clearTimeout(this.errorTimeout)}))}getChatById(t){return this.chatData.find(e=>e.id===t)}switchChat(e,t=null){if(e){var s,a=this.getChatById(e);if(a)try{this.activeChatId=e,this.renderMessages(a.messages),this.sidebar&&(0===(s=this.sidebar.querySelectorAll(this.sidebarContactSelector)).length?console.warn("No sidebar items found with selector:",this.sidebarContactSelector):s.forEach(e=>e.classList.remove("active"))),t&&t.classList.add("active"),this.chatInput&&this.chatInput.focus(),this.usernameElement&&a.contact?.name&&(this.usernameElement.textContent=a.contact.name),setTimeout(()=>{if(this.chatContent)try{var e=window.SimpleBar?.instances?.get(this.chatContent),t=e?e.getScrollElement():this.chatContent;t.scrollTop=t.scrollHeight}catch(e){console.error("Error while scrolling chat:",e)}},50)}catch(e){console.error("Error in switchChat:",e),this.showError("An error occurred while switching chats")}else this.showError(`Chat with ID ${e} not found`),console.warn(`Chat with ID ${e} not found in chatData`)}else console.warn("switchChat called without chatId")}renderMessages(e){if(e)if(this.chatContent)try{var t=window.SimpleBar?.instances?.get(this.chatContent),s=t?t.getContentElement():this.chatContent;if(s){let a=e=>{var t;return"string"!=typeof e?"":((t=document.createElement("div")).textContent=e,t.innerHTML)};if(s.innerHTML=e.filter(e=>e&&"object"==typeof e&&"text"in e).map(e=>{var t="me"===e.from,s=e.avatar||"assets/images/users/default-avatar.png";return`
                    <div class="d-flex align-items-start gap-2 my-3 chat-item ${t?"text-end justify-content-end":""}">
                    ${t?"":`<img src="${s}" class="avatar-md rounded-circle" alt="User">`}
                        <div>
                            <div class="chat-message py-2 px-3 ${t?"bg-info-subtle":"bg-warning-subtle"} rounded">${a(e.text)}</div>
                            <div class="text-muted fs-xs mt-1">
                                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0" />
                                    <path d="M12 7v5l3 3" />
                                </svg> ${a(e.time||"")}
                            </div>
                        </div>
                    ${t?`<img src="${s}" class="avatar-md rounded-circle" alt="User">`:""}
                        </div>`}).join(""),t)try{t.recalculate();var r=t.getScrollElement();r&&(r.scrollTop=r.scrollHeight)}catch(e){console.error("Error updating SimpleBar scroll:",e),this.chatContent.scrollTop=this.chatContent.scrollHeight}else this.chatContent&&(this.chatContent.scrollTop=this.chatContent.scrollHeight)}else console.error("Could not find scroll content element")}catch(e){console.error("Error rendering messages:",e),this.showError("Failed to load messages. Please refresh the page.")}else console.error("Chat content element not found");else console.warn("No messages provided to render")}sendMessage(){if(this.chatInput)if(this.activeChatId){var e=this.chatInput.value.trim();if(this.errorTimeout&&clearTimeout(this.errorTimeout),e)try{var t,s=this.getChatById(this.activeChatId);s?(Array.isArray(s.messages)||(s.messages=[]),t={from:"me",text:e,time:(new Date).toLocaleTimeString([],{hour:"2-digit",minute:"2-digit"}).toLowerCase(),avatar:"assets/images/users/user-2.jpg"},s.messages.push(t),this.chatInput.value="",this.sendButton&&(this.sendButton.disabled=!0),this.renderMessages(s.messages),this.simulateIncomingMessage(s.id)):(this.showError("Chat not found"),console.error(`Chat with ID ${this.activeChatId} not found`))}catch(e){console.error("Error sending message:",e),this.showError("Failed to send message. Please try again.")}else this.showError("Message cannot be empty")}else this.showError("No active chat selected");else console.error("Chat input element not found")}setupSearch(){this.searchInput&&this.searchInput.addEventListener("keyup",e=>{let s=e.target.value.toLowerCase();document.querySelector(".list-group").querySelectorAll(".list-group-item").forEach(e=>{var t=[...e.querySelectorAll("[data-chat-search-field]")].some(e=>e.textContent.toLowerCase().includes(s));e.style.setProperty("display",t?"":"none","important")})})}simulateIncomingMessage(t){let s=this.getChatById(t);if(s){var a=["Can't chat, calls only","😑😑😑","👍","Thanks!","Talk soon.","No worries 😄"],r=(new Date).toLocaleTimeString([],{hour:"2-digit",minute:"2-digit"}).toLowerCase();let e={from:s.contact.name,text:a[Math.floor(Math.random()*a.length)],time:r,avatar:s.contact.avatar};setTimeout(()=>{s.messages.push(e),this.activeChatId===t&&this.renderMessages(s.messages)},2e3*Math.random()+1e3)}}}let chatData=[{id:"chat1",contact:{name:"Ava Thompson",avatar:"assets/images/users/user-4.jpg"},messages:[{from:"Ava Thompson",text:"Hey! Are you available for a quick call? 📞",time:"08:55 am",avatar:"assets/images/users/user-4.jpg"},{from:"me",text:"Sure, give me 5 minutes. Just wrapping something up.",time:"08:57 am",avatar:"assets/images/users/user-2.jpg"},{from:"Ava Thompson",text:"Perfect. Let me know when you're ready 👍",time:"08:58 am",avatar:"assets/images/users/user-4.jpg"},{from:"me",text:"Ready now. Calling you!",time:"09:00 am",avatar:"assets/images/users/user-2.jpg"},{from:"Ava Thompson",text:"Thanks for your time earlier!",time:"09:45 am",avatar:"assets/images/users/user-4.jpg"},{from:"me",text:"Of course! It was a productive discussion.",time:"09:46 am",avatar:"assets/images/users/user-2.jpg"},{from:"Ava Thompson",text:"I’ll send over the updated files by noon.",time:"09:50 am",avatar:"assets/images/users/user-4.jpg"},{from:"me",text:"Great, I’ll review them once they arrive.",time:"09:52 am",avatar:"assets/images/users/user-2.jpg"},{from:"Ava Thompson",text:"Just sent them via Drive. Let me know if you have issues accessing.",time:"12:03 pm",avatar:"assets/images/users/user-4.jpg"},{from:"me",text:"Got them. Everything looks good so far!",time:"12:10 pm",avatar:"assets/images/users/user-2.jpg"},{from:"Ava Thompson",text:"Awesome 😊 Looking forward to your feedback!",time:"12:12 pm",avatar:"assets/images/users/user-4.jpg"},{from:"me",text:"Will get back to you after lunch 🍴",time:"12:13 pm",avatar:"assets/images/users/user-2.jpg"},{from:"Ava Thompson",text:"No rush, enjoy your lunch! 😄",time:"12:14 pm",avatar:"assets/images/users/user-4.jpg"},{from:"me",text:"Thanks! Talk soon.",time:"12:15 pm",avatar:"assets/images/users/user-2.jpg"}]},{id:"chat2",contact:{name:"Noah Smith",avatar:"assets/images/users/user-5.jpg"},messages:[{from:"Noah Smith",text:"Hey, quick question—did you check the latest design mockups?",time:"10:05 am",avatar:"assets/images/users/user-5.jpg"},{from:"me",text:"Not yet, just logging in now. Want me to prioritize that?",time:"10:06 am",avatar:"assets/images/users/user-2.jpg"},{from:"Noah Smith",text:"Yes please. I need your feedback before the client review at noon.",time:"10:07 am",avatar:"assets/images/users/user-5.jpg"},{from:"me",text:"Got it. I’ll go through them and send notes in a bit.",time:"10:08 am",avatar:"assets/images/users/user-2.jpg"},{from:"Noah Smith",text:"Thanks a ton!",time:"10:08 am",avatar:"assets/images/users/user-5.jpg"},{from:"me",text:"First impression: very clean. Minor spacing issues though.",time:"10:20 am",avatar:"assets/images/users/user-2.jpg"},{from:"Noah Smith",text:"Noted. Fixing those now.",time:"10:21 am",avatar:"assets/images/users/user-5.jpg"},{from:"me",text:"Sent detailed feedback via email too 📬",time:"10:25 am",avatar:"assets/images/users/user-2.jpg"},{from:"Noah Smith",text:"Got it. Appreciate the quick turnaround!",time:"10:26 am",avatar:"assets/images/users/user-5.jpg"}]},{id:"chat3",contact:{name:"Liam Turner",avatar:"assets/images/users/user-7.jpg"},messages:[{from:"Liam Turner",text:"Morning! Did you update the backend endpoints yet?",time:"09:15 am",avatar:"assets/images/users/user-7.jpg"},{from:"me",text:"Morning! Just pushed the changes to dev branch.",time:"09:16 am",avatar:"assets/images/users/user-2.jpg"},{from:"Liam Turner",text:"Awesome, I’ll pull and test on my side.",time:"09:17 am",avatar:"assets/images/users/user-7.jpg"},{from:"me",text:"Let me know if anything breaks ⚠️",time:"09:18 am",avatar:"assets/images/users/user-2.jpg"},{from:"Liam Turner",text:"Looks good so far. Just one CORS error.",time:"09:20 am",avatar:"assets/images/users/user-7.jpg"},{from:"me",text:"Ah, forgot the whitelist entry. Fixing now.",time:"09:21 am",avatar:"assets/images/users/user-2.jpg"},{from:"Liam Turner",text:"Reloaded… and it's working. All green ✅",time:"09:23 am",avatar:"assets/images/users/user-7.jpg"},{from:"me",text:"Nice! That wraps our side for this sprint then?",time:"09:24 am",avatar:"assets/images/users/user-2.jpg"},{from:"Liam Turner",text:"Yep. Good work 💪",time:"09:25 am",avatar:"assets/images/users/user-7.jpg"}]},{id:"chat4",contact:{name:"Emma Wilson",avatar:"assets/images/users/user-4.jpg"},messages:[{from:"Ava Thompson",text:"Hey! Are you available for a quick call? 📞",time:"08:55 am",avatar:"assets/images/users/user-4.jpg"},{from:"me",text:"Sure, give me 5 minutes. Just wrapping something up.",time:"08:57 am",avatar:"assets/images/users/user-2.jpg"},{from:"Ava Thompson",text:"Perfect. Let me know when you're ready 👍",time:"08:58 am",avatar:"assets/images/users/user-4.jpg"},{from:"me",text:"Ready now. Calling you!",time:"09:00 am",avatar:"assets/images/users/user-2.jpg"},{from:"Ava Thompson",text:"Thanks for your time earlier!",time:"09:45 am",avatar:"assets/images/users/user-4.jpg"},{from:"me",text:"Of course! It was a productive discussion.",time:"09:46 am",avatar:"assets/images/users/user-2.jpg"},{from:"Ava Thompson",text:"I’ll send over the updated files by noon.",time:"09:50 am",avatar:"assets/images/users/user-4.jpg"},{from:"me",text:"Great, I’ll review them once they arrive.",time:"09:52 am",avatar:"assets/images/users/user-2.jpg"}]},{id:"chat5",contact:{name:"Olivia Martinez",avatar:"assets/images/users/user-8.jpg"},messages:[{from:"Olivia Martinez",text:"Thanks a ton!",time:"10:08 am",avatar:"assets/images/users/user-8.jpg"},{from:"me",text:"First impression: very clean. Minor spacing issues though.",time:"10:20 am",avatar:"assets/images/users/user-2.jpg"},{from:"Olivia Martinez",text:"Noted. Fixing those now.",time:"10:21 am",avatar:"assets/images/users/user-8.jpg"},{from:"me",text:"Sent detailed feedback via email too 📬",time:"10:25 am",avatar:"assets/images/users/user-2.jpg"},{from:"Olivia Martinez",text:"Got it. Appreciate the quick turnaround!",time:"10:26 am",avatar:"assets/images/users/user-8.jpg"}]},{id:"chat6",contact:{name:"William Davis",avatar:"assets/images/users/user-7.jpg"},messages:[{from:"William Davis",text:"Looks good so far. Just one CORS error.",time:"09:20 am",avatar:"assets/images/users/user-7.jpg"},{from:"me",text:"Ah, forgot the whitelist entry. Fixing now.",time:"09:21 am",avatar:"assets/images/users/user-2.jpg"},{from:"William Davis",text:"Reloaded… and it's working. All green ✅",time:"09:23 am",avatar:"assets/images/users/user-7.jpg"},{from:"me",text:"Nice! That wraps our side for this sprint then?",time:"09:24 am",avatar:"assets/images/users/user-2.jpg"},{from:"William Davis",text:"Yep. Good work 💪",time:"09:25 am",avatar:"assets/images/users/user-7.jpg"}]},{id:"chat7",contact:{name:"Sophia Moore",avatar:"assets/images/users/user-10.jpg"},messages:[{from:"me",text:"Of course! It was a productive discussion.",time:"09:46 am",avatar:"assets/images/users/user-2.jpg"},{from:"Sophia Moore",text:"I’ll send over the updated files by noon.",time:"09:50 am",avatar:"assets/images/users/user-10.jpg"},{from:"me",text:"Great, I’ll review them once they arrive.",time:"09:52 am",avatar:"assets/images/users/user-2.jpg"},{from:"Sophia Moore",text:"Just sent them via Drive. Let me know if you have issues accessing.",time:"12:03 pm",avatar:"assets/images/users/user-10.jpg"},{from:"me",text:"Got them. Everything looks good so far!",time:"12:10 pm",avatar:"assets/images/users/user-2.jpg"},{from:"Sophia Moore",text:"Awesome 😊 Looking forward to your feedback!",time:"12:12 pm",avatar:"assets/images/users/user-10.jpg"},{from:"me",text:"Will get back to you after lunch 🍴",time:"12:13 pm",avatar:"assets/images/users/user-2.jpg"},{from:"Sophia Moore",text:"No rush, enjoy your lunch! 😄",time:"12:14 pm",avatar:"assets/images/users/user-10.jpg"},{from:"me",text:"Thanks! Talk soon.",time:"12:15 pm",avatar:"assets/images/users/user-2.jpg"}]},{id:"chat8",contact:{name:"Jackson Lee",avatar:"assets/images/users/user-2.jpg"},messages:[{from:"Jackson Lee",text:"Thanks a ton!",time:"10:08 am",avatar:"assets/images/users/user-2.jpg"},{from:"me",text:"First impression: very clean. Minor spacing issues though.",time:"10:20 am",avatar:"assets/images/users/user-2.jpg"},{from:"Jackson Lee",text:"Noted. Fixing those now.",time:"10:21 am",avatar:"assets/images/users/user-2.jpg"},{from:"me",text:"Sent detailed feedback via email too 📬",time:"10:25 am",avatar:"assets/images/users/user-2.jpg"},{from:"Jackson Lee",text:"Got it. Appreciate the quick turnaround!",time:"10:26 am",avatar:"assets/images/users/user-2.jpg"}]},{id:"chat9",contact:{name:"Chloe Anderson",avatar:"assets/images/users/user-3.jpg"},messages:[{from:"Chloe Anderson",text:"Looks good so far. Just one CORS error.",time:"09:20 am",avatar:"assets/images/users/user-3.jpg"},{from:"me",text:"Ah, forgot the whitelist entry. Fixing now.",time:"09:21 am",avatar:"assets/images/users/user-2.jpg"},{from:"Chloe Anderson",text:"Reloaded… and it's working. All green ✅",time:"09:23 am",avatar:"assets/images/users/user-3.jpg"},{from:"me",text:"Nice! That wraps our side for this sprint then?",time:"09:24 am",avatar:"assets/images/users/user-2.jpg"},{from:"Chloe Anderson",text:"Yep. Good work 💪",time:"09:25 am",avatar:"assets/images/users/user-3.jpg"}]},{id:"chat10",contact:{name:"Lucas Wright",avatar:"assets/images/users/user-4.jpg"},messages:[{from:"me",text:"Great, I’ll review them once they arrive.",time:"09:52 am",avatar:"assets/images/users/user-2.jpg"},{from:"Lucas Wright",text:"Just sent them via Drive. Let me know if you have issues accessing.",time:"12:03 pm",avatar:"assets/images/users/user-4.jpg"},{from:"me",text:"Got them. Everything looks good so far!",time:"12:10 pm",avatar:"assets/images/users/user-2.jpg"},{from:"Lucas Wright",text:"Awesome 😊 Looking forward to your feedback!",time:"12:12 pm",avatar:"assets/images/users/user-4.jpg"},{from:"me",text:"Will get back to you after lunch 🍴",time:"12:13 pm",avatar:"assets/images/users/user-2.jpg"},{from:"Lucas Wright",text:"No rush, enjoy your lunch! 😄",time:"12:14 pm",avatar:"assets/images/users/user-4.jpg"},{from:"me",text:"Thanks! Talk soon.",time:"12:15 pm",avatar:"assets/images/users/user-2.jpg"}]},{id:"chat11",contact:{name:"Mia Scott",avatar:"assets/images/users/user-6.jpg"},messages:[{from:"me",text:"First impression: very clean. Minor spacing issues though.",time:"10:20 am",avatar:"assets/images/users/user-2.jpg"},{from:"Mia Scott",text:"Noted. Fixing those now.",time:"10:21 am",avatar:"assets/images/users/user-6.jpg"},{from:"me",text:"Sent detailed feedback via email too 📬",time:"10:25 am",avatar:"assets/images/users/user-2.jpg"},{from:"Mia Scott",text:"Got it. Appreciate the quick turnaround!",time:"10:26 am",avatar:"assets/images/users/user-6.jpg"}]},{id:"chat12",contact:{name:"Benjamin Clark",avatar:"assets/images/users/user-9.jpg"},messages:[{from:"Benjamin Clark",text:"Looks good so far. Just one CORS error.",time:"09:20 am",avatar:"assets/images/users/user-9.jpg"},{from:"me",text:"Ah, forgot the whitelist entry. Fixing now.",time:"09:21 am",avatar:"assets/images/users/user-2.jpg"},{from:"Benjamin Clark",text:"Reloaded… and it's working. All green ✅",time:"09:23 am",avatar:"assets/images/users/user-9.jpg"},{from:"me",text:"Nice! That wraps our side for this sprint then?",time:"09:24 am",avatar:"assets/images/users/user-2.jpg"},{from:"Benjamin Clark",text:"Yep. Good work 💪",time:"09:25 am",avatar:"assets/images/users/user-9.jpg"}]}];document.addEventListener("DOMContentLoaded",()=>{try{new Chat({data:chatData})}catch(e){console.error("Failed to initialize chat:",e)}});