<?php $__env->startPush('css'); ?>
<style>
    .profile-detail-logo { max-width: 100px; overflow: hidden; border-radius: 8px; }
    .profile-detail-logo img { width: 100px; height: 100px; object-fit: cover; border-radius: 8px; display: block; }
    .profile-detail-list { list-style: none; padding: 0; margin: 0; }
    .profile-detail-list li { display: flex; justify-content: space-between; align-items: center; padding: 10px 0; border-bottom: 1px solid #f0f0f0; }
    .profile-detail-list li:last-child { border-bottom: 0; }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<?php
$profileCv = $user->getDefaultCv();
$profile_skills = $user->profileSkills;
$skills_arr = array();
if (null !== $profile_skills) {
    foreach ($profile_skills as $value) {
        $skills_arr[] = $value->job_skill_id;
    }
}
$job_ids = \App\JobApply::where('user_id', $user->id)->orderBy('id', 'DESC')->get();
?>
<div class="page-bar mb-3">
    <ul class="page-breadcrumb mb-0">
        <li><a href="<?php echo e(route('admin.home')); ?>">Home</a> <i class="ri ri-arrow-right-s-line text-muted"></i></li>
        <li><a href="<?php echo e(route('list.users')); ?>">Users</a> <i class="ri ri-arrow-right-s-line text-muted"></i></li>
        <li><span>Applicant Profile</span></li>
    </ul>
</div>


<div class="card mb-4">
    <div class="card-body">
        <div class="row align-items-start">
            <div class="col-md-8">
                <div class="d-flex align-items-start gap-3">
                    <div class="flex-shrink-0 profile-detail-logo"><?php echo $user->printUserImage(100, 100); ?></div>
                    <div>
                        <h4 class="mb-1"><?php echo e($user->getName()); ?></h4>
                        <?php if($user->address): ?>
                        <p class="text-muted mb-1 small"><?php echo e($user->address); ?></p>
                        <?php endif; ?>
                        <p class="mb-2 small text-muted">
                            <i class="ri ri-calendar-line me-1"></i> <?php echo e(__('Member Since')); ?>, <?php echo e($user->created_at->format('M d, Y')); ?>

                        </p>
                        <div class="d-flex flex-wrap gap-2">
                            <?php if(Auth::guard('admin')->user()): ?>
                                <?php if(count($user->profileCvs) <= 0): ?>
                                <span class="btn btn-sm btn-secondary disabled"><?php echo e(__('No CV Available')); ?></span>
                                <?php else: ?>
                                <a href="<?php echo e(asset('cvs/'.$profileCv->cv_file)); ?>" target="_blank" class="btn btn-sm btn-outline-primary"><?php echo e(__('View Candidates CV')); ?></a>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if(null !== $profileCv && !empty($profileCv->cv_file) && file_exists(public_path('cvs/'.$profileCv->cv_file))): ?>
                            <a href="<?php echo e(asset('cvs/'.$profileCv->cv_file)); ?>" target="_blank" class="btn btn-sm btn-outline-success"><i class="ri ri-download-line me-1"></i><?php echo e(__('Download CV')); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row g-3">
    <div class="col-lg-8">
        
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0"><i class="ri ri-information-line me-1"></i> About Me (Summary)</h5>
            </div>
            <div class="card-body">
                <p class="mb-0"><?php echo e($user->getProfileSummary('summary') ?: '–'); ?></p>
            </div>
        </div>

        
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0"><i class="ri ri-graduation-cap-line me-1"></i> <?php echo e(__('Education')); ?></h5>
            </div>
            <div class="card-body">
                <div id="education_div"></div>
            </div>
        </div>

        
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0"><i class="ri ri-briefcase-4-line me-1"></i> <?php echo e(__('Experience')); ?></h5>
            </div>
            <div class="card-body">
                <div id="experience_div"></div>
            </div>
        </div>

        
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0"><i class="ri ri-folder-open-line me-1"></i> <?php echo e(__('Portfolio')); ?></h5>
            </div>
            <div class="card-body">
                <div id="projects_div"></div>
            </div>
        </div>

        
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0"><i class="ri ri-file-list-3-line me-1"></i> <?php echo e(__('Applied On Jobs')); ?></h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover table-align-middle mb-0" id="user_datatable_ajax">
                        <thead class="table-light">
                            <tr>
                                <th>Name</th>
                                <th>Job Title</th>
                                <th>Company Name</th>
                                <th>Applied Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if($job_ids->count()): ?>
                            <?php $__currentLoopData = $job_ids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $jobb = \App\Job::find($jo->job_id);
                                $userr = \App\User::find($jo->user_id);
                                $companyy = $jobb ? $jobb->getCompany() : null;
                            ?>
                            <?php if($companyy && $jobb): ?>
                            <tr id="user_dt_row_<?php echo e($jo->id); ?>">
                                <td><?php echo e($userr ? $userr->name : '–'); ?></td>
                                <td><a href="<?php echo e(route('public.job', ['id' => $jo->job_id])); ?>" target="_blank"><?php echo e($jobb->title); ?></a></td>
                                <td><?php echo e($companyy->name); ?></td>
                                <td><?php echo e(date('d/m/Y', strtotime($jo->created_at))); ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <tr><td colspan="4" class="text-muted text-center py-4"><?php echo e(__('No applications yet.')); ?></td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-4">
        
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0"><i class="ri ri-contacts-line me-1"></i> <?php echo e(__('Candidate Contact Details')); ?></h5>
            </div>
            <div class="card-body">
                <?php if(!empty($user->phone)): ?>
                <p class="mb-1 small"><i class="ri ri-phone-line me-1 text-muted"></i> <a href="tel:<?php echo e($user->phone); ?>"><?php echo e($user->phone); ?></a></p>
                <?php endif; ?>
                <?php if(!empty($user->mobile_num)): ?>
                <p class="mb-1 small"><i class="ri ri-smartphone-line me-1 text-muted"></i> <a href="tel:<?php echo e($user->mobile_num); ?>"><?php echo e($user->mobile_num); ?></a></p>
                <?php endif; ?>
                <?php if(!empty($user->email)): ?>
                <p class="mb-1 small"><i class="ri ri-mail-line me-1 text-muted"></i> <a href="mailto:<?php echo e($user->email); ?>"><?php echo e($user->email); ?></a></p>
                <?php endif; ?>
                <p class="mb-0 small"><i class="ri ri-map-pin-line me-1 text-muted"></i> <?php echo e($user->getLocation()); ?></p>
            </div>
        </div>

        
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0"><i class="ri ri-user-settings-line me-1"></i> <?php echo e(__('Candidate Details')); ?></h5>
            </div>
            <div class="card-body">
                <ul class="profile-detail-list">
                    <li><span class="text-muted"><?php echo e(__('Available Immediately')); ?></span><span><?php echo e((bool)$user->is_immediate_available ? __('Yes') : __('No')); ?></span></li>
                    <?php if(!(bool)$user->is_immediate_available): ?>
                    <li><span class="text-muted">Available from</span><span><?php echo e($user->immediate_date_from ? date('d/m/Y', strtotime($user->immediate_date_from)) : date('d/m/Y')); ?></span></li>
                    <?php endif; ?>
                    <li><span class="text-muted"><?php echo e(__('Eligible to work in the UK:')); ?></span><span><?php echo e((bool)$user->eligible_uk ? __('Yes') : __('No')); ?></span></li>
                    <li><span class="text-muted"><?php echo e(__('Eligible to work in the EU:')); ?></span><span><?php echo e((bool)$user->eligible_eu ? __('Yes') : __('No')); ?></span></li>
                    <li><span class="text-muted"><?php echo e(__('Age')); ?></span><span><?php echo e($user->getAge()); ?> Years</span></li>
                    <?php if(null !== $user->getGender('gender')): ?>
                    <li><span class="text-muted"><?php echo e(__('Gender')); ?></span><span><?php echo e($user->getGender('gender')); ?></span></li>
                    <?php endif; ?>
                    <?php if(null !== $user->getMaritalStatus('marital_status')): ?>
                    <li><span class="text-muted"><?php echo e(__('Marital Status')); ?></span><span><?php echo e($user->getMaritalStatus('marital_status')); ?></span></li>
                    <?php endif; ?>
                    <?php if(isset($user->education_id) && $user->education_id && optional($user->education)->degree_level): ?>
                    <li><span class="text-muted"><?php echo e(__('Education')); ?></span><span><?php echo e($user->education->degree_level); ?></span></li>
                    <?php endif; ?>
                    <li><span class="text-muted"><?php echo e(__('Experience')); ?></span><span><?php echo e($user->getJobExperience('job_experience') ?? '–'); ?></span></li>
                    <li><span class="text-muted"><?php echo e(__('Career Level')); ?></span><span><?php echo e($user->getCareerLevel('career_level') ?? '–'); ?></span></li>
                    <li><span class="text-muted"><?php echo e(__('Current Salary')); ?></span><span><?php echo e($user->salary_currency ?? ''); ?><?php echo e($user->current_salary ?? '–'); ?></span></li>
                    <li><span class="text-muted"><?php echo e(__('Expected Salary')); ?></span><span><?php echo e($user->salary_currency ?? ''); ?><?php echo e($user->expected_salary ?? '–'); ?></span></li>
                </ul>
            </div>
        </div>

        
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0"><i class="ri ri-file-text-line me-1"></i> <?php echo e(__('CV Added')); ?></h5>
            </div>
            <div class="card-body">
                <?php if(count($user->profileCvs) <= 0): ?>
                <span class="text-danger fw-semibold"><?php echo e(__('No')); ?></span>
                <?php else: ?>
                <span class="text-success fw-semibold"><?php echo e(__('Yes')); ?></span>
                <?php endif; ?>
            </div>
        </div>

        
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0"><i class="ri ri-lightbulb-line me-1"></i> <?php echo e(__('Skills')); ?></h5>
            </div>
            <div class="card-body">
                <div id="skill_div"></div>
            </div>
        </div>

        
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0"><i class="ri ri-translate-2 me-1"></i> <?php echo e(__('Languages')); ?></h5>
            </div>
            <div class="card-body">
                <div id="language_div"></div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style type="text/css">.formrow iframe { height: 78px; }</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(function() {
    showEducation();
    showProjects();
    showExperience();
    showSkills();
    showLanguages();

    function showProjects() {
        $.post("<?php echo e(route('show.applicant.profile.projects', $user->id)); ?>", { user_id: <?php echo e($user->id); ?>, _method: 'POST', _token: '<?php echo e(csrf_token()); ?>' })
            .done(function(response) { $('#projects_div').html(response); });
    }
    function showExperience() {
        $.post("<?php echo e(route('show.applicant.profile.experience', $user->id)); ?>", { user_id: <?php echo e($user->id); ?>, _method: 'POST', _token: '<?php echo e(csrf_token()); ?>' })
            .done(function(response) { $('#experience_div').html(response); });
    }
    function showEducation() {
        $.post("<?php echo e(route('show.applicant.profile.education', $user->id)); ?>", { user_id: <?php echo e($user->id); ?>, _method: 'POST', _token: '<?php echo e(csrf_token()); ?>' })
            .done(function(response) { $('#education_div').html(response); });
    }
    function showLanguages() {
        $.post("<?php echo e(route('show.applicant.profile.languages', $user->id)); ?>", { user_id: <?php echo e($user->id); ?>, _method: 'POST', _token: '<?php echo e(csrf_token()); ?>' })
            .done(function(response) { $('#language_div').html(response); });
    }
    function showSkills() {
        $.post("<?php echo e(route('show.applicant.profile.skills', $user->id)); ?>", { user_id: <?php echo e($user->id); ?>, _method: 'POST', _token: '<?php echo e(csrf_token()); ?>' })
            .done(function(response) { $('#skill_div').html(response); });
    }

    if ($.fn.DataTable && $('#user_datatable_ajax tbody tr').length > 0 && $('#user_datatable_ajax tbody tr td').first().attr('colspan') !== '4') {
        $('#user_datatable_ajax').DataTable({ orderable: false, paging: true, pageLength: 10 });
    }
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp8\htdocs\jp2026\resources\views/admin/user/applicant_profile.blade.php ENDPATH**/ ?>