<?php if($packages->count()): ?>
<div class="user-pkg-section">
    <div class="user-pkg-section-header">
        <h3><i class="fas fa-arrow-circle-up"></i> <?php echo e(__('Upgrade Your Package')); ?></h3>
        <p><?php echo e(__('Get more features and benefits with an upgraded package')); ?></p>
    </div>
    
    <div class="row">
        <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-4 col-sm-6">
            <div class="user-pkg-card">
                <div class="user-pkg-card-header">
                    <h4><?php echo e($package->package_title); ?></h4>
                    <?php if($package->id == 9): ?>
                        <span class="user-pkg-badge featured"><?php echo e(__('Featured')); ?></span>
                    <?php endif; ?>
                </div>
                
                <div class="user-pkg-price">
                    <span class="user-pkg-currency">$</span>
                    <span class="user-pkg-amount"><?php echo e($package->package_price); ?></span>
                </div>
                
                <div class="user-pkg-features">
                    <div class="user-pkg-feature">
                        <i class="fas fa-calendar-alt"></i>
                        <span><?php echo e($package->package_num_days); ?> <?php echo e(__('Days')); ?></span>
                    </div>
                    <?php if($package->package_num_listings > 0): ?>
                    <div class="user-pkg-feature">
                        <i class="fas fa-briefcase"></i>
                        <span><?php echo e($package->package_num_listings); ?> <?php echo e(__('Job Applications')); ?></span>
                    </div>
                    <?php endif; ?>
                    <div class="user-pkg-feature">
                        <i class="fas fa-calendar-alt"></i>
                        <span><?php echo e(__('Premium Support 24/7')); ?></span>
                    </div>


                    <?php if($package->id == 9): ?>
                    <div class="user-pkg-feature">
                        <i class="fas fa-star"></i>
                        <span><?php echo e(__('Featured Profile Badge')); ?></span>
                    </div>
                    <?php endif; ?>
                </div>
                
                <?php if($package->package_price > 0): ?>
                    <button type="button" class="user-pkg-btn" data-bs-toggle="modal" data-bs-target="#paymentModal<?php echo e($package->id); ?>">
                        <i class="fas fa-arrow-up"></i> <?php echo e(__('Upgrade Now')); ?>

                    </button>
                <?php else: ?>
                    <a href="<?php echo e(route('order.free.package', $package->id)); ?>" class="user-pkg-btn">
                        <i class="fas fa-gift"></i> <?php echo e(__('Get Free Package')); ?>

                    </a>
                <?php endif; ?>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<!-- Payment Gateway Modals -->
<?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="paymentModal<?php echo e($package->id); ?>" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__('Select Payment Method')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <h6 class="mb-3"><?php echo e(__('Package')); ?>: <strong><?php echo e($package->package_title); ?> ($<?php echo e($package->package_price); ?>)</strong></h6>
                <div class="payment-methods">
                    <?php if((bool)$siteSetting->is_paypal_active): ?>
                    <a href="javascript:void(0)" onclick="checkPaymentGateway('paypal', '<?php echo e(!empty($siteSetting->paypal_client_id) && !empty($siteSetting->paypal_secret)); ?>', '<?php echo e(route('order.upgrade.package', $package->id)); ?>')" class="payment-method-btn">
                        <i class="fab fa-cc-paypal"></i> <?php echo e(__('Pay with PayPal')); ?>

                    </a>
                    <?php endif; ?>
                    <?php if((bool)$siteSetting->is_stripe_active): ?>
                    <a href="javascript:void(0)" onclick="checkPaymentGateway('stripe', '<?php echo e(!empty($siteSetting->stripe_key) && !empty($siteSetting->stripe_secret)); ?>', '<?php echo e(route('stripe.order.form', [$package->id, 'upgrade'])); ?>')" class="payment-method-btn">
                        <i class="fab fa-cc-stripe"></i> <?php echo e(__('Pay with Stripe')); ?>

                    </a>
                    <?php endif; ?>
                    <?php if((bool)$siteSetting->is_razorpay_active): ?>
                    <a href="javascript:void(0)" onclick="checkPaymentGateway('razorpay', '<?php echo e(!empty($siteSetting->razorpay_key) && !empty($siteSetting->razorpay_secret)); ?>', '<?php echo e(route('razorpay.order.form', [$package->id, 'upgrade'])); ?>')" class="payment-method-btn">
                        <i class="fas fa-credit-card"></i> <?php echo e(__('Pay with Razorpay')); ?>

                    </a>
                    <?php endif; ?>
                    <?php if((bool)$siteSetting->is_paytm_active): ?>
                    <a href="javascript:void(0)" onclick="checkPaymentGateway('paytm', '<?php echo e(!empty($siteSetting->paytm_merchant_key) && !empty($siteSetting->paytm_merchant_id)); ?>', '<?php echo e(route('paytm.order.form', [$package->id, 'upgrade'])); ?>')" class="payment-method-btn">
                        <i class="fas fa-credit-card"></i> <?php echo e(__('Pay with Paytm')); ?>

                    </a>
                    <?php endif; ?>
                    <?php if((bool)$siteSetting->is_payu_active): ?>
                    <a href="javascript:void(0)" onclick="checkPaymentGateway('payu', '<?php echo e(!empty($siteSetting->payu_money_key) && !empty($siteSetting->salt)); ?>', '<?php echo e(route('payu.order.package', ['package_id='.$package->id, 'type=upgrade'])); ?>')" class="payment-method-btn">
                        <i class="fas fa-credit-card"></i> <?php echo e(__('Pay with PayU')); ?>

                    </a>
                    <?php endif; ?>
                    <?php if((bool)$siteSetting->is_paystack_active): ?>
                    <a href="javascript:void(0)" onclick="checkPaymentGateway('paystack', '<?php echo e(!empty($siteSetting->paystack_key) && !empty($siteSetting->paystack_secret)); ?>', '<?php echo e(route('paystack.order.form', [$package->id, 'upgrade'])); ?>')" class="payment-method-btn">
                        <i class="fas fa-credit-card"></i> <?php echo e(__('Pay with Paystack')); ?>

                    </a>
                    <?php endif; ?>
                    <?php if((bool)$siteSetting->is_iyzico_active): ?>
                    <a href="javascript:void(0)" onclick="checkPaymentGateway('iyzico', '<?php echo e(!empty($siteSetting->iyzico_api_key) && !empty($siteSetting->iyzico_secret_key)); ?>', '<?php echo e(route('iyzico.order.form', [$package->id, 'upgrade'])); ?>')" class="payment-method-btn">
                        <i class="fas fa-credit-card"></i> <?php echo e(__('Pay with Iyzico')); ?>

                    </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<!-- Payment Gateway Error Modal -->
<div class="modal fade" id="paymentGatewayErrorModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__('Payment Gateway Error')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-danger">
                    <p id="paymentGatewayErrorMsg"></p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
            </div>
        </div>
    </div>
</div>

<script>
function checkPaymentGateway(gateway, isConfigured, redirectUrl) {
    // Close the payment selection modal if one is open
    const openModal = document.querySelector('.modal.show');
    if (openModal) {
        const modalInstance = bootstrap.Modal.getInstance(openModal);
        if (modalInstance) {
            modalInstance.hide();
        }
    }
    
    if (isConfigured === '1') {
        window.location.href = redirectUrl;
    } else {
        document.getElementById('paymentGatewayErrorMsg').innerHTML = '<?php echo e(__("This payment gateway is not properly configured. Please contact the administrator.")); ?>';
        new bootstrap.Modal(document.getElementById('paymentGatewayErrorModal')).show();
    }
}
</script>
<?php endif; ?>
<?php /**PATH D:\xampp8\htdocs\jp2026\resources\views/includes/user_packages_upgrade.blade.php ENDPATH**/ ?>