<?php if(count($errors) > 0): ?>
<div class="alert alert-danger">
    There were some problems with your input.
</div>
<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php echo e($error); ?><br/>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="form-body">
    <div class="form-group mb-3 <?php echo APFrmErrHelp::hasError($errors, 'role_name'); ?>">
        <?php echo Form::label('role_name', 'Role Name', ['class' => 'bold']); ?>

        <?php echo Form::text('role_name', null, ['required', 'class' => 'form-control', 'placeholder' => 'e.g. Content Editor']); ?>

        <?php echo APFrmErrHelp::showErrors($errors, 'role_name'); ?>

    </div>
    <div class="form-group mb-3 <?php echo APFrmErrHelp::hasError($errors, 'role_abbreviation'); ?>">
        <?php echo Form::label('role_abbreviation', 'Abbreviation', ['class' => 'bold']); ?>

        <?php echo Form::text('role_abbreviation', null, ['required', 'class' => 'form-control', 'placeholder' => 'e.g. CONT_ED']); ?>

        <?php echo APFrmErrHelp::showErrors($errors, 'role_abbreviation'); ?>

    </div>
    <div class="form-group mb-3 <?php echo APFrmErrHelp::hasError($errors, 'role_description'); ?>">
        <?php echo Form::label('role_description', 'Description', ['class' => 'bold']); ?>

        <?php echo Form::text('role_description', null, ['class' => 'form-control', 'placeholder' => 'Short description']); ?>

        <?php echo APFrmErrHelp::showErrors($errors, 'role_description'); ?>

    </div>

    <div class="form-group mb-3">
        <label class="bold">Permissions</label>
        <p class="text-muted small">Select which permissions this role has. Permissions are grouped by module.</p>
        <div class="border rounded p-3" style="max-height: 400px; overflow-y: auto;">
            <?php $__empty_1 = true; $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="mb-3">
                <strong class="text-primary"><?php echo e($module ?: 'General'); ?></strong>
                <div class="ms-3 mt-1">
                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="form-check">
                        <?php echo Form::checkbox('permissions[]', $perm->id, in_array($perm->id, $rolePermissionIds ?? []), ['class' => 'form-check-input', 'id' => 'perm_' . $perm->id]); ?>

                        <label class="form-check-label" for="perm_<?php echo e($perm->id); ?>"><?php echo e($perm->name); ?> <small class="text-muted">(<?php echo e($perm->slug); ?>)</small></label>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <p class="text-muted">No permissions defined. Run migrations to seed default permissions: <code>php artisan migrate</code></p>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH D:\xampp8\htdocs\jp2026\resources\views/admin/roles/add_edit_form.blade.php ENDPATH**/ ?>