<?php $__env->startSection('content'); ?>

<style type="text/css">
    .table td, .table th {
        font-size: 13px;
        line-height: 2.42857 !important;
    }
</style>

<link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">

<div class="page-content-wrapper">
    <div class="page-content">
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li> <a href="<?php echo e(route('admin.home')); ?>">Home</a> <i class="fa fa-circle"></i> </li>
                <li> <span>Applied Users</span> </li>
            </ul>
        </div>
        
        <?php
            if(!isset($job) && Request::segment(3)){
                $job = App\Job::findOrFail(Request::segment(3));
            }
        ?>
        
        <div class="row">
            <div class="col-md-12">
                <div class="myads">
                    <h3><?php echo e(__('Candidates listed against')); ?> (<?php echo e(isset($job) ? $job->title : ''); ?>)</h3>
                    <button id="downloadCsv" class="btn btn-success">Download CSV</button>
                    <br><br>
                    <table id="appliedUsersTable" class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>Candidate Name</th>
                                <th>Location</th>
                                <th>Expected Salary</th>
                                <th>Experience</th>
                                <th>Career Level</th>
                                <th>Phone</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(isset($job_applications) && count($job_applications)): ?>
                                <?php $__currentLoopData = $job_applications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job_application): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $user = $job_application->getUser();
                                        $job = $job_application->getJob();
                                        $company = $job->getCompany();             
                                        $profileCv = $job_application->getProfileCv();
                                    ?>
                                    <?php if($user && $job && $company && $profileCv): ?>
                                        <tr>
                                            <td><a href="<?php echo e(route('admin.view.public.profile', $user->id)); ?>"><?php echo e($user->getName()); ?></a></td>
                                            <td><?php echo e($user->getLocation()); ?></td>
                                            <td><?php echo e($job_application->expected_salary); ?> <?php echo e($job_application->salary_currency); ?></td>
                                            <td><?php echo e($user->getJobExperience('job_experience')); ?></td>
                                            <td><?php echo e($user->getCareerLevel('career_level')); ?></td>
                                            <td><?php echo e($user->phone); ?></td>
                                            <td>
                                                <?php
                                                    $status = $job_application->status ?: 'applied';
                                                    $statusLabels = [
                                                        'applied' => ['label' => 'Applied', 'class' => 'badge-info'],
                                                        'shortlist' => ['label' => 'Shortlisted', 'class' => 'badge-success'],
                                                        'hired' => ['label' => 'Hired', 'class' => 'badge-primary'],
                                                        'rejected' => ['label' => 'Rejected', 'class' => 'badge-danger']
                                                    ];
                                                    $statusInfo = isset($statusLabels[$status]) ? $statusLabels[$status] : ['label' => ucfirst($status), 'class' => 'badge-default'];
                                                ?>
                                                <span class="badge <?php echo e($statusInfo['class']); ?>"><?php echo e($statusInfo['label']); ?></span>
                                            </td>
                                            <td>
                                                <a class="btn btn-primary btn-sm" href="<?php echo e(route('admin.view.public.profile', [$user->id, 'company_id='.$company_id, 'job_id='.$job_id])); ?>">View Profile</a>
                                                <?php if(isset($job) && $job->jobQuestions->count() > 0): ?>
                                                <button type="button" class="btn btn-info btn-sm" data-toggle="modal" data-target="#viewAnswersModal<?php echo e($job_application->id); ?>">
                                                    View Answers
                                                </button>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="8" class="text-center">No Candidates applied yet</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script>
    $(document).ready(function() {
        $('#appliedUsersTable').DataTable();

        $('#downloadCsv').click(function () {
            let csvContent = "data:text/csv;charset=utf-8," + "Name,Location,Expected Salary,Experience,Career Level,Phone,Status\n";
            
            <?php if(isset($job_applications) && count($job_applications)): ?>
                <?php $__currentLoopData = $job_applications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job_application): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $user = $job_application->getUser();
                        $job = $job_application->getJob();
                        $status = $job_application->status ?: 'applied';
                        $statusLabels = [
                            'applied' => 'Applied',
                            'shortlist' => 'Shortlisted',
                            'hired' => 'Hired',
                            'rejected' => 'Rejected'
                        ];
                        $statusLabel = isset($statusLabels[$status]) ? $statusLabels[$status] : ucfirst($status);
                    ?>
                    <?php if($user && $job): ?>
                        csvContent += `"<?php echo e($user->getName()); ?>","<?php echo e($user->getLocation()); ?>","<?php echo e($job_application->expected_salary); ?> <?php echo e($job_application->salary_currency); ?>","<?php echo e($user->getJobExperience('job_experience')); ?>","<?php echo e($user->getCareerLevel('career_level')); ?>","<?php echo e($user->phone); ?>","<?php echo e($statusLabel); ?>"\n`;
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>

            let encodedUri = encodeURI(csvContent);
            let link = document.createElement("a");
            link.setAttribute("href", encodedUri);
            link.setAttribute("download", "applied_users_<?php echo e($job->title); ?>.csv");
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        });
    });
</script>

<!-- Modals for View Answers -->
<?php if(isset($job_applications) && count($job_applications) && isset($job) && $job->jobQuestions->count() > 0): ?>
    <?php $__currentLoopData = $job_applications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job_application): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $user = $job_application->getUser();
        ?>
        <?php if(null !== $job_application && null !== $user): ?>
        <div class="modal fade" id="viewAnswersModal<?php echo e($job_application->id); ?>" tabindex="-1" role="dialog" aria-labelledby="viewAnswersModalLabel<?php echo e($job_application->id); ?>">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="viewAnswersModalLabel<?php echo e($job_application->id); ?>"><?php echo e(__('Answers for')); ?> <?php echo e($user->getName()); ?></h4>
                    </div>
                    <div class="modal-body">
                        <?php
                            $answers = \App\JobQuestionAnswer::where('job_apply_id', $job_application->id)
                                ->with('jobQuestion')
                                ->get()
                                ->keyBy('job_question_id');
                        ?>
                        <?php $__currentLoopData = $job->jobQuestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mb-4">
                                <h5><strong><?php echo e($question->question_title); ?></strong></h5>
                                <div class="answer-box p-3" style="background-color: #f5f5f5; border-radius: 4px;">
                                    <?php if(isset($answers[$question->id])): ?>
                                        <p class="mb-0"><?php echo e($answers[$question->id]->answer ?: __('No answer provided')); ?></p>
                                    <?php else: ?>
                                        <p class="mb-0 text-muted"><?php echo e(__('No answer provided')); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp8\htdocs\jp2026\resources\views/admin/job/job_applications.blade.php ENDPATH**/ ?>