
<?php $__env->startSection('content'); ?>
<!-- Header start -->
<?php echo $__env->make('includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Header end --> 
<!-- Inner Page Title start -->
<?php echo $__env->make('includes.inner_page_title', ['page_title'=>__('Applied Jobs')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Inner Page Title end -->
<div class="listpgWraper">
    <div class="container">
        <div class="row">
            <?php echo $__env->make('includes.user_dashboard_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="col-md-9 col-sm-8"> 
                <div class="myads">
                    
                    <?php if(isset($appliedJobs) && count($appliedJobs) > 0): ?>
                        <ul class="featuredlist row">
                            <?php $__currentLoopData = $appliedJobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appliedjob): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $job = $appliedjob->job;
                                    $company = $job ? $job->company : null;
                                ?>
                                <?php if($job && $company): ?>
                                    <li class="col-lg-4 col-md-6 <?php if($job->is_featured == 1): ?> featured <?php endif; ?>">
                                        <div class="jobint mt-0 mb-3">
                                            <?php if($job->is_featured == 1): ?> 
                                                <span class="promotepof-badge"><i class="fa fa-bolt" title="<?php echo e(__('Featured Job')); ?>"></i></span> 
                                            <?php endif; ?>
                                            <div class="d-flex justify-content-between align-items-center mb-2">
                                                <div class="fticon"><i class="fas fa-briefcase"></i> <?php echo e($job->getJobType('job_type')); ?></div>
                                                <?php
                                                    $statusClass = 'secondary';
                                                    if ($appliedjob->status == 'pending') {
                                                        $statusClass = 'warning';
                                                    } elseif (in_array($appliedjob->status, ['approved', 'hire', 'hired'])) {
                                                        $statusClass = 'success';
                                                    } elseif ($appliedjob->status == 'rejected') {
                                                        $statusClass = 'danger';
                                                    }
                                                ?>
                                                <strong class="badge bg-<?php echo e($statusClass); ?>">
                                                    <?php echo e(ucfirst($appliedjob->status)); ?>

                                                </strong>
                                            </div>
                                            <h4>
                                                <a href="<?php echo e(route('job.detail', [$job->slug])); ?>" title="<?php echo e($job->title); ?>">
                                                    <?php echo \Illuminate\Support\Str::limit($job->title, 25, '...'); ?>

                                                </a>
                                            </h4>                                        
                                            <?php if(!(bool)$job->hide_salary): ?>                    
                                                <div class="salary mb-2"><?php echo e(__('Salary')); ?>: 
                                                    <strong><?php echo e($job->salary_currency.''.$job->salary_from); ?> - <?php echo e($job->salary_currency.''.$job->salary_to); ?>/<?php echo e($job->getSalaryPeriod('salary_period')); ?></strong>
                                                </div>
                                            <?php endif; ?> 
                                            <strong><i class="fas fa-map-marker-alt"></i> <?php echo e($job->getCity('city')); ?></strong>                                         
                                            <div class="jobcompany">
                                                <div class="ftjobcomp">
                                                    <span><?php echo e(__('Applied')); ?>: <?php echo e($appliedjob->created_at->format('M d, Y')); ?></span>
                                                    <a href="<?php echo e(route('company.detail', $company->slug)); ?>" title="<?php echo e($company->name); ?>"><?php echo e($company->name); ?></a>
                                                </div>
                                                <a href="<?php echo e(route('company.detail', $company->slug)); ?>" class="company-logo" title="<?php echo e($company->name); ?>"><?php echo e($company->printCompanyImage()); ?></a>
                                            </div>
                                        </div>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        
                        <!-- Pagination -->
                        <div class="d-flex justify-content-center mt-4">
                            <?php echo e($appliedJobs->links()); ?>

                        </div>
                    <?php else: ?>
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> <?php echo e(__('No applied jobs found')); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<?php echo $__env->make('includes.immediate_available_btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp8\htdocs\jp2026\resources\views/job/my_applied_jobs.blade.php ENDPATH**/ ?>