<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('job_question_answers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('job_question_id');
            $table->unsignedBigInteger('job_apply_id');
            $table->text('answer')->nullable();
            $table->timestamps();
            
            $table->index(['job_question_id', 'job_apply_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('job_question_answers');
    }
};
